<?PHP
#
#   FILE:  DeletePage.php (Pages plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

# if page was not specified
$PFactory = new Pages_PageFactory();
if (!isset($_GET["ID"]))
{
    # set error display
    $H_DisplayMode = "NoPageSpecified";
}
# else if specified page does not exist
elseif (!$PFactory->ItemExists($_GET["ID"]))
{
    # set error display
    $H_DisplayMode = "PageDoesNotExist";
}
else
{
    # load page
    $H_Page = new Pages_Page($_GET["ID"]);

    # make sure user has privileges to delete page
    $Plugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
    $NeededPrivileges = array($Plugin->ConfigSetting("PrivilegeToEdit"));
    if ($GLOBALS["G_User"]->IsLoggedIn() 
            && ($GLOBALS["G_User"]->Id() == $H_Page->AuthorId()))
    {
        $NeededPrivileges[] = $Plugin->ConfigSetting("PrivilegeToAuthor");
    }
    if (!CheckAuthorization($NeededPrivileges)) {  return;  }

    # if we are processing confirmation
    if (isset($_GET["AC"]) && ($_GET["AC"] == "Confirmation"))
    {
        # if delete was confirmed
        if (isset($_POST["Submit"]) && ($_POST["Submit"] == "Delete"))
        {
            # hook function to delete page after HTML is displayed
            function DeletePage($Id)
            {
                $PFactory = new Pages_PageFactory();
                $PFactory->DeleteItem($Id);
            }
            $GLOBALS["AF"]->AddPostProcessingCall("DeletePage", $_GET["ID"]);
    
            # inform user that page was deleted
            $H_DisplayMode = "PageDeleted";
        }
        # else if delete was cancelled
        elseif (isset($_POST["Submit"]) && ($_POST["Submit"] == "Cancel"))
        {
            # return to referring page
            $GLOBALS["AF"]->SetJumpToPage(isset($_POST["F_Referer"])
                    ? $_POST["F_Referer"] : "Pages_ListPages");
        }
    }
    # else assume that confirmation is needed
    else
    {
        $H_DisplayMode = "ConfirmationNeeded";
    }
}

