<?PHP
#
#   FILE:  AccountPruner.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

class AccountPruner extends Plugin {

    function Register()
    {
        $this->Name = "User Account Pruner";
        $this->Version = "1.0.0";
        $this->Description = "Automatically prunes user accounts"
                ." that have never been activated.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
                "CWISCore" => "2.2.2");
        $this->EnabledByDefault = FALSE;

        $this->CfgSetup["UnactivatedFrequency"] = array(
                "Type" => "Option",
                "Label" => "Prune Unactivated Accounts Every",
                "Help" => "How often to prune accounts that have never"
                        ." been activated and/or used.",
                "Options" => array(
                        "Never" => "Never",
                        "Daily" => "Daily",
                        "Weekly" => "Weekly",
                        "Monthly" => "Monthly",
                        "Once" => "Once",
                        ),
                );
        $this->CfgSetup["UnactivatedDays"] = array(
                "Type" => "Number",
                "Label" => "Prune Unactivated Accounts After",
                "Size" => 4,
                "Units" => "days",
                "Help" => "Number of days that must have elapsed since creation"
                        ." before accounts that have never been activated and/or"
                        ." used are pruned.",
                );
    }

    function Install()
    {
        $this->ConfigSetting("UnactivatedDays", 30);
    }

    function HookEvents()
    {
        if ($this->ConfigSetting("UnactivatedFrequency") == "Daily")
            return array("EVENT_DAILY" => "PruneUnactivatedAccounts");
        elseif ($this->ConfigSetting("UnactivatedFrequency") == "Weekly")
            return array("EVENT_WEEKLY" => "PruneUnactivatedAccounts");
        elseif ($this->ConfigSetting("UnactivatedFrequency") == "Monthly")
            return array("EVENT_MONTHLY" => "PruneUnactivatedAccounts");
        elseif ($this->ConfigSetting("UnactivatedFrequency") == "Once")
            return array("EVENT_PERIODIC" => "PruneUnactivatedAccounts");
        else
            return array();
    }

    function PruneUnactivatedAccounts($LastRunAt)
    {
        # bail out if no number of days specified
        if (!strlen(trim($this->ConfigSetting("UnactivatedDays")))) {  return;  }

        # turn off pruning if we are set to only run once
        if ($this->ConfigSetting("UnactivatedFrequency") == "Once")
        {
            $this->ConfigSetting("UnactivatedFrequency", "Never");
        }

        # find all accounts unactivated and older than specified number of days
        $DB = new Database();
        $DB->Query("SELECT UserId FROM APUsers"
                ." WHERE LastLoginDate = '0000-00-00 00:00:00'"
                ." AND CreationDate < DATE_SUB(NOW(), INTERVAL "
                        .intval($this->ConfigSetting("UnactivatedDays"))." DAY)");
        $UserIds = $DB->FetchColumn("UserId");

        # for each account
        foreach ($UserIds as $Id)
        {
            # delete account
            $User = new User($DB, $Id);
            $User->Delete();
        }
    }
}

?>
