<?PHP
#
#   FILE:  MyResourceViews.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

class MyResourceViews extends Plugin {

    function Register()
    {
        $this->Name = "My Resource Views";
        $this->Version = "1.0.0";
        $this->Description = "Displays list of resources that user"
                ." has most recently viewed in a box in the sidebar.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
                "CWISCore" => "2.2.0",
                "MetricsRecorder" => "1.1.1",
                );
        $this->EnabledByDefault = FALSE;

        $this->CfgSetup["BoxHeader"] = array(
                "Type" => "Text",
                "Label" => "Box Header",
                "Help" => "Title for <i>My Resource Views</i> box in sidebar.",
                "Size" => 40,
                "MaxLength" => 60,
                );
        $this->CfgSetup["ListLength"] = array(
                "Type" => "Number",
                "Label" => "Number of Resources to Display",
                "Help" => "Number of recent-viewed resources to display in box.",
                "MaxVal" => 20,
                );
    }

    function Install()
    {
        $this->ConfigSetting("BoxHeader", "Recently Viewed");
        $this->ConfigSetting("ListLength", 5);
    }

    function HookEvents()
    {
        return array(
                "EVENT_REQUEST_SIDEBAR_CONTENT" => "GenerateRecentlyViewedBox",
                );
    }

    function GenerateRecentlyViewedBox()
    {
        # if the user is logged in
        $Box = "";
        if ($GLOBALS["G_User"]->IsLoggedIn())
        {
            # get the list length + 5 in case some resources cannot be displayed
            $NumToFetch = $this->ConfigSetting("ListLength") + 5;

            # retrieve list of resources recently viewed by user
            $MRecorder = $GLOBALS["G_PluginManager"]->GetPlugin("MetricsRecorder");
            $Views = $MRecorder->GetFullRecordViews($GLOBALS["G_User"], $NumToFetch);

            $Schema = new MetadataSchema();
            $HtmlAllowed = $Schema->GetFieldByMappedName("Title")->AllowHTML();
            $Resources = array();

            # get the resources from the views
            foreach ($Views as $View)
            {
                $Resource = new Resource($View["ResourceId"]);

                # make sure the user can actually view the resource
                if ($Resource->UserCanView($GLOBALS["G_User"]))
                {
                    $Resources[] = $Resource;
                }

                # stop if enough resources have been found
                if (count($Resources) >= $this->ConfigSetting("ListLength"))
                {
                    break;
                }
            }

            # if there were resources found
            if (count($Resources))
            {
                ob_start();
                ?><div class="cw-section cw-section-simple cw-html5-section">
                    <div class="cw-section-header cw-html5-header">
                        <b><?PHP  print($this->ConfigSetting("BoxHeader"));  ?></b>
                    </div>
                    <div class="cw-section-body">
                        <ul class="cw-list cw-list-noindent cw-list-dotlist">
                            <?PHP
                            # for each resource
                            foreach ($Resources as $Rsrc)
                            {
                                # format link to full record page
                                $Link = "index.php?P=FullRecord&amp;"
                                        ."ID=".$Rsrc->Id();

                                # format view label
                                $Title = $Rsrc->GetMapped("Title");
                                $Label = $HtmlAllowed
                                    ? $Title : defaulthtmlentities($Title);

                                # add resource view to list in box
                                ?><li><a href="<?PHP  print($Link);
                                ?>"><?PHP  print($Label);  ?></a></li><?PHP
                            }
                        ?></ul>
                    </div>
                </div><?PHP
                $Box = ob_get_contents();
                ob_end_clean();
            }
        }

        # return generated box to caller
        return $Box;
    }
}
