<?PHP

#
#   FILE:  SPTUserFactory.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

class SPTUserFactory extends UserFactory
{
    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
     * Get the users sorted by how many resources they have added or edited,
     * starting with those who have added/edited the most. By default, the number
     * of users returned is five.
     * @param $Limit the maximum number of users to return
     */
    public function GetTopContributors($Limit = 5)
    {
        # assume no users will be found
        $Users = array();

        # fetch the top contributors
        $DB = new Database();
        $DB->Query("SELECT U.*"
                ." FROM APUsers U, Resources R"
                ." WHERE U.UserId = R.LastModifiedById"
                ." GROUP BY R.LastModifiedById"
                ." ORDER BY COUNT(*) DESC"
                ." LIMIT ".intval($Limit));
        $UserIds = $DB->FetchColumn("UserId");

        # for each user id found
        foreach ($UserIds as $UserId)
        {
            $Users[$UserId] = new SPTUser($UserId);
        }

        # return the newest users
        return $Users;
    }

    /**
     * Get the users sorted by when they last added or edited a resource
     * starting with those who added/edited a resource most recently. By default,
     * the number of users returned is five.
     * @param $Limit the maximum number of users to return
     */
    public function GetMostRecentContributors($Limit = 5)
    {
        # assume no users will be found
        $Users = array();

        # fetch the top contributors
        $DB = new Database();
        $DB->Query("SELECT U.*"
                ." FROM APUsers U, Resources R"
                ." WHERE U.UserId = R.LastModifiedById"
                ." GROUP BY U.UserId"
                ." ORDER BY MAX(R.DateLastModified) DESC"
                ." LIMIT ".intval($Limit));
        $UserIds = $DB->FetchColumn("UserId");

        # for each user id found
        foreach ($UserIds as $UserId)
        {
            $Users[$UserId] = new SPTUser($UserId);
        }

        # return the newest users
        return $Users;
    }

    # ---- PRIVATE INTERFACE -------------------------------------------------

}

?>
