<?PHP
#
#   FILE:  AddTopic.php
#
#   FUNCTIONS PROVIDED:
#       PrintForumId()
#       PrintForumName()
#       PrintErrorMessages()
#       DisplayTopics()
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumName()
{
    global $ForumName;

    print StripXSSThreats(stripslashes($ForumName));
}

function PrintTopic()
{
    global $F_TopicName;

    print StripXSSThreats(stripslashes($F_TopicName));
}

function PrintSubject()
{
    global $F_Subject;

    print StripXSSThreats(defaulthtmlentities($F_Subject));
}

function PrintBody()
{
    global $F_Body;

    print StripXSSThreats(defaulthtmlentities($F_Body));
}

# print out any error messages
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed
    if (count($ErrorMessages) > 0)
    {
        # print error messages
        print("<ul>\n");
        foreach ($ErrorMessages as $Message)
        {
            printf("<li>%s</li>\n", $Message);
        }
        print("</ul>\n");
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function GetFromSession($VarName){
    $Value = NULL;
    if (isset($_SESSION[$VarName]))
    {
        $Value = $_SESSION[$VarName];
        unset ($_SESSION[$VarName]);
    }
    return $Value;
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $F_Body;
global $F_Subject;
global $F_TopicName;
global $ForumId;
global $ForumName;

if (isset($_GET["ForumId"]))
    $ForumId = intval($_GET["ForumId"]);
elseif (isset($_SESSION["ForumId"]))
    $ForumId = $_SESSION["ForumId"];
$Forum = new Forum($ForumId);
$ForumName = $Forum->ForumName();

if (isset($_POST["F_TopicName"]))
    $F_TopicName = $_POST["F_TopicName"];
elseif (isset($_SESSION["F_TopicName"]))
    $F_TopicName = GetFromSession("F_TopicName");
if (isset($_POST["F_Subject"]))
    $F_Subject = $_POST["F_Subject"];
elseif (isset($_SESSION["F_Subject"]))
    $F_Subject = GetFromSession("F_Subject");
if (isset($_POST["F_Body"]))
    $F_Body = $_POST["F_Body"];
elseif (isset($_SESSION["F_Body"]))
    $F_Body = GetFromSession("F_Body");

if (isset($_SESSION["ErrorMessages"]))
{
    $ErrorMessages = $_SESSION["ErrorMessages"];
    unset($_SESSION["ErrorMessages"]);
}

PageTitle("Add Topic");
if (!CheckAuthorization(PRIV_POSTTOFORUMS)) {  return;  }

?>
