<?PHP
#
#   FILE:  RateResource.php
#
#   FORM FIELDS EXPECTED:
#       F_ResourceId
#           - ID of resource to be rated
#       F_Rating
#           - rating to be given to resource
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu
#

# ----- MAIN -----------------------------------------------------------------

$ResourceId = (isset($_GET["F_ResourceId"])) ? intval($_GET["F_ResourceId"]) : NULL;
$Rating = (isset($_GET["F_Rating"])) ? intval($_GET["F_Rating"]) : NULL;

# check for the rating in POST variables
if (is_null($Rating) && isset($_POST["F_Rating"]))
{
    $Rating = intval($_POST["F_Rating"]);
}

# save the new rating for the user
if (!is_null($ResourceId))
{
    if (!is_null($Rating))
    {
        $Resource = new Resource($ResourceId);
        $Resource->Rating($Rating);
    }

    # go to full record page
    $AF->SetJumpToPage("FullRecord&ID=".$ResourceId);
}

# go to the home page
else
{
    $AF->SetJumpToPage("Home");
}

