<?PHP

#
#   FILE:  MessageFactory.php
#
#   Part of the Collection Workflow Integration System
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

/**
 * Factory for forum messages / resource comments.
 * \nosubgrouping
 */

class MessageFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /** @name Setup/Initialization */
    /*@{*/

    /** Object constructor */
    public function MessageFactory()
    {
        $this->ItemFactory("Message", "Messages", "MessageId", "Subject");
    }

    /*@}*/

    /** @name Accessors */
    /*@{*/

    /**
     * Get all messages posted by specified user, in reverse date order.
     * @param UserId ID of user.
     * @param Count Number of messages to retrieve.  (OPTIONAL)
     * @return Array of messages.
     */
    public function GetMessagesPostedByUser($UserId, $Count = NULL)
    {
        # retrieve message IDs posted by specified user
        $this->DB->Query("SELECT MessageId FROM Messages"
                ." WHERE PosterId = ".intval($UserId)
                ." ORDER BY DatePosted DESC"
                .($Count ? " LIMIT ".intval($Count) : ""));
        $MessageIds = $this->DB->FetchColumn("MessageId");

        # load messages based on message IDs
        $Messages = array();
        foreach ($MessageIds as $Id)
        {
            $Messages[$Id] = new Message($Id);
        }

        # return array of message IDs to caller
        return $Messages;
    }

    /*@}*/

    # ---- PRIVATE INTERFACE -------------------------------------------------

}
