<?PHP
#
#   FILE:  ConfirmRemoveUser.php
#
#   FUNCTIONS PROVIDED:
#       PrintUserName()
#       - print out topic name
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to return true if users have been selected for removal
function RemoveUsersExist()
{
    global $UserRemoveArray;

    return count($UserRemoveArray);
}

function PrintUserList()
{
    global $Session, $UserRemoveArray;

    $DB = new Database();

    foreach ($UserRemoveArray as $UserId)
    {
        $RemoveUser = new User($DB, intval($UserId));
        print $RemoveUser->Get("UserName")."<br>";
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $UserRemoveArray;
global $H_TriedRemovingOwnAccount;

PageTitle("Confirm Remove User");

# check if current user is authorized
CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN);

# get the list of users to remove
$UserRemoveArray = $Session->Get("UserRemoveArray");

# check if the user is trying to remove his or her own account
$OwnIdKey = array_search($GLOBALS["User"]->Id(), $UserRemoveArray);
$H_TriedRemovingOwnAccount = FALSE;

# the user tried to remove his or her own account, so don't allow it
if ($OwnIdKey !== FALSE)
{
    $H_TriedRemovingOwnAccount = TRUE;
    unset($UserRemoveArray[$OwnIdKey]);
}

# pass along the values to the removal page
$Session->PassVariable("OkayToRemove", 1);
$Session->PassVariable("UserRemoveArray", $UserRemoveArray);
