<?php
#
#   FILE:  DBEditor.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTextFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();
    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_TEXT,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTextFieldRow($Field);
    }
}

function PrintParagraphFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_PARAGRAPH,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintParagraphFieldRow($Field);
    }
}

function PrintNumberFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_NUMBER,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintNumberFieldRow($Field);
    }
}

function PrintPointFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_POINT,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintPointFieldRow($Field);
    }
}

function PrintDateFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_DATE,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintDateFieldRow($Field);
    }
}

function PrintTimestampFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_TIMESTAMP,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTimestampFieldRow($Field);
    }
}

function PrintFlagFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_FLAG,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintFlagFieldRow($Field);
    }
}

function PrintTreeFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_TREE,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTreeFieldRow($Field);
    }
}

function PrintControlledNameFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_CONTROLLEDNAME,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintControlledNameFieldRow($Field);
    }
}

/**
 * THIS FUNCTION HAS BEEN DEPRECATED
 * Use PrintControlledNameFieldAttributes() instead
 */
function PrintContolledNameFieldAttributes()
{
    PrintControlledNameFieldAttributes();
}

function PrintOptionFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_OPTION,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintOptionFieldRow($Field);
    }
}

function PrintUserFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_USER,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintUserFieldRow($Field);
    }
}

function PrintImageFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_IMAGE,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintImageFieldRow($Field);
    }
}

function PrintFileFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_FILE,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintFileFieldRow($Field);
    }
}

function PrintUrlFieldAttributes()
{
    # Get the schema
    $Schema = new MetadataSchema();
    # Get the fields for the schema
    $Fields = $Schema->GetFields(MetadataSchema::MDFTYPE_URL,
            MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintUrlFieldRow($Field);
    }
}

function PrintDefaultValue($Field)
{
    $DefaultValue = $Field->DefaultValue();

    if ($DefaultValue)
    {
        $Type = $Field->Type();

        if ($Type == MetadataSchema::MDFTYPE_OPTION)
        {
            if (!is_array($DefaultValue))
            {
                $DefaultValue = array($DefaultValue);
            }

            $Count = 0;

            foreach ($DefaultValue as $Value)
            {
                $ControlledName = new ControlledName($Value);

                print "<i>".defaulthtmlentities($ControlledName->Name())."</i>";

                $Count++;

                if ($Count < count($DefaultValue))
                {
                    print ", ";
                }
            }
        }

        else if ($Type == MetadataSchema::MDFTYPE_POINT)
        {
            $X = defaulthtmlentities($DefaultValue["X"]);
            $Y = defaulthtmlentities($DefaultValue["Y"]);

            print "X: <i>".$X."</i>, Y: <i>".$Y."</i>";
        }

        else
        {
            print "<i>".defaulthtmlentities($Field->DefaultValue())."</i>";
        }
    }

    else
    {
        print "[No default value]";
    }
}

function PrintHasItemLevelQualifiers($Field)
{
    print GetYesNo($Field->HasItemLevelQualifiers());
}

function PrintDefaultQualifier($Field)
{
    $DefaultQualifier = $Field->DefaultQualifier();
    if ($DefaultQualifier > 0)
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        print defaulthtmlentities($Qualifier->Name());
    }
    else
        print "--";
}

/**
 * Transform a list of privilege names in various formats to a list of only
 * those privilege names that are valid along with their values. This was taken
 * from the NavEditor plugin.
 * @param $Privileges an array of privilege names
 * @return an array of valid privileges, with the name as the key
 */
function TransformPrivileges(array $Privileges)
{
    $PrivilegeFactory = new PrivilegeFactory();
    $AllPrivileges = $PrivilegeFactory->GetPrivileges(TRUE, FALSE);
    $PrivilegeConstants = $PrivilegeFactory->GetPredefinedPrivilegeConstants();
    $ValidPrivileges = array();

    foreach ($Privileges as $Privilege)
    {
        # predefined privilege name
        if (in_array($Privilege, $PrivilegeConstants))
        {
            $Key = $Privilege;
            $Value = array_search($Key, $PrivilegeConstants);

            $ValidPrivileges[$Key] = $Value;
        }

        # predefined privilege name without the PRIV_ prefix
        else if (in_array("PRIV_".$Privilege, $PrivilegeConstants))
        {
            $Key = "PRIV_".$Privilege;
            $Value = array_search($Key, $PrivilegeConstants);

            $ValidPrivileges[$Key] = $Value;
        }

        # predefined privilege description or custom privilege name
        else if (in_array($Privilege, $AllPrivileges))
        {
            $Key = $Privilege;
            $Value = array_search($Key, $AllPrivileges);

            $ValidPrivileges[$Key] = $Value;
        }

        else if (array_key_exists($Privilege, $AllPrivileges))
        {
            $Key = $AllPrivileges[$Privilege];
            $Value = $Privilege;

            $ValidPrivileges[$Key] = $Value;
        }
    }

    return $ValidPrivileges;
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# translate 1=Yes, 0=No
function GetYesNo($Var)
{
    return ($Var ? "Yes" : "No");
}

# translate flag on or flag off label
function GetFlagValue($Field)
{
    return ($Field->DefaultValue() ? $Field->FlagOnLabel() :
                $Field->FlagOffLabel());
}

# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN)) {  return;  }

PageTitle("Metadata Field Editor");
