<?PHP
#
#   FILE:  SPT--ImportDataOai.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2008 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

PageTitle("Import Data (OAI-PMH)");

# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

/*
STEPS:
- get URL
- read and display repository identification
    - get metadata format
- read schema, determine field set, guess field mappings
    - display field set and get mappings and identifying fields
- import records (repeat as necessary)
- display summary of import operation
*/

switch (isset($_POST["F_Submit"]) ? $_POST["F_Submit"] : NULL)
{
    case "Begin":
        $Client = new OAIClient($_POST["F_Repository"]);
        $Client->SetDebugLevel(0);
        $G_IdentInfo = $Client->GetIdentification();
        $G_AvailableFormats = $Client->GetFormats();
        PrintForDebug("G_IdentInfo", $G_IdentInfo);
        PrintForDebug("G_AvailableFormats", $G_AvailableFormats);
        break;

    default:
        break;
}

$G_RepUrl = "http://localhost/~ealmasy/scout/SPT/SPT--OAI.php";

?>
