<?php
#
#   FILE:  PostMessage.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#       DisplayAddButtons()
#           - display add, delete, cancel buttons
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

require_once("lib/AxisPHP/Axis--StandardLibrary.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function CheckForEdit()
{
    global $MessageId, $User, $ModeratorId, $PosterId;

    if (!empty($MessageId) && ($User->Get("UserId") == $ModeratorId ||
        $User->Get("UserId") == $PosterId || $User->HasPriv(PRIV_SYSADMIN)))
        return true;
    else
        return false;
}

function PrintForumId()
{
    global $ForumId;

    print $ForumId;
}

function PrintForumName()
{
    global $ForumName;

    print stripslashes($ForumName);
}

function PrintParentId()
{
    global $ParentId;

    print $ParentId;
}

function PrintTopic()
{
    global $F_TopicName;

    print stripslashes($F_TopicName);
}

function PrintMessageId()
{
    global $MessageId;

    print stripslashes($MessageId);
}

function PrintSubject()
{
    global $F_Subject;

    print defaulthtmlentities($F_Subject);
}

function PrintBody()
{
    global $F_Body;

    print defaulthtmlentities($F_Body);
}

# print out any error messages
function PrintErrorMessages()
{
    global $ErrorMessages;

    # if error messages were passed
    if (count($ErrorMessages) > 0)
    {
        if (function_exists("PrintErrorMessage"))
        {
            foreach ($ErrorMessages as $Message)
            {
                PrintErrorMessage($Message);
            }
        }

        else
        {
            # print error messages
            print("<ul>\n");
            foreach ($ErrorMessages as $Message)
            {
                printf("<li>%s</li>\n", $Message);
            }
            print("</ul>\n");
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ErrorMessages;
global $F_Body;
global $F_Subject;
global $F_TopicName;
global $ForumId;
global $ForumName;
global $MessageId;
global $ModeratorId;
global $ParentId;
global $PosterId;


if (isset($_GET["TopicId"]))
{
    $TopicId = intval($_GET["TopicId"]);
    $ParentId = $TopicId;
}
else if (isset($_SESSION["TopicId"]))
{
    $TopicId = $_SESSION["TopicId"];
    $ParentId = $TopicId;
}

if (isset($TopicId))
    $Topic = new Topic($TopicId);

$F_TopicName = $Topic->TopicName();

if (isset($_GET["ForumId"]))
    $ForumId = intval($_GET["ForumId"]);
else if (isset($_SESSION["ForumId"]))
    $ForumId = $_SESSION["ForumId"];

if (isset($ForumId))
    $Forum = new Forum($ForumId);

$ForumName = $Forum->ForumName();
$ModeratorId = $Forum->ModeratorId();

if (isset($_GET["MessageId"]))
{
    $MessageId = intval($_GET["MessageId"]);
    $Message = new Message($MessageId);
    $F_Subject = isset($_SESSION["F_Subject"])
        ? $_SESSION["F_Subject"] : $Message->Subject();
    $F_Body = isset($_SESSION["F_Body"])
        ? $_SESSION["F_Body"] : $Message->Body();
    $PosterId = $Message->PosterId();
    $IsUpdate = isset($_SESSION["IsUpdate"])
        ? $_SESSION["IsUpdate"] : False ;
}
else
{
    if (isset($_POST["F_Subject"]))
        $F_Subject = $_POST["F_Subject"];
    elseif (isset($_SESSION["F_Subject"]))
        $F_Subject = $_SESSION["F_Subject"];

    if (isset($_POST["F_Body"]))
        $F_Body = $_POST["F_Body"];
    elseif (isset($_SESSION["F_Body"]))
        $F_Body = $_SESSION["F_Body"];
}

PageTitle("Post Message");
if (!CheckAuthorization( PRIV_POSTTOFORUMS )) {  return;  }
