<?PHP
#
#   FILE:  SPT--ActivateAccount.php
#
#   FUNCTIONS PROVIDED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function supplied for use in HTML file
#
#   FUNCTIONS EXPECTED:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file must supply
#
#   OPTIONAL FUNCTIONS:
#       FunctionName($Parameter, $Parameter)
#           - brief description of function that HTML file may supply
#
#   FORM FIELDS EXPECTED:
#       F_FormFieldName
#           - brief description of form field purpose and/or content
#
#   Part of the Scout Portal Toolkit
#   Copyright 2006 Internet Scout Project
#   http://scout.wisc.edu
#

PageTitle("New Account Reset");


# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

global $G_UserFound;
global $G_ResetCode;
global $G_ResetCodeConfirmed;
global $G_ManualEntryUsed;
global $G_PasswordChanged;

# assume that all checks/actions will fail
$G_UserFound = FALSE;
$G_ResetCodeConfirmed = FALSE;
$G_ManualEntryUsed = FALSE;
$G_PasswordChanged = FALSE;

# retrieve user name and password reset code from URL or form
if (isset($_GET["UN"]) && strlen(trim($_GET["UN"])))
{
    $UserName = $_GET["UN"];
}
elseif (isset($_POST["F_UserName"]) 
        && strlen(trim($_POST["F_UserName"])))
{
    $UserName = $_POST["F_UserName"];
    $G_ManualEntryUsed = TRUE;
}
if (isset($_GET["RC"]) && strlen(trim($_GET["RC"])))
{
    $ResetCode = $_GET["RC"];
}
elseif (isset($_POST["F_ResetCode"]) 
        && strlen(trim($_POST["F_ResetCode"])))
{
    $ResetCode = $_POST["F_ResetCode"];
    $G_ManualEntryUsed = TRUE;
}

# if user name and confirmation code found
if (isset($UserName) && isset($ResetCode))
{
    # check user name
    $TargetUser = new SPTUser($UserName);

    # if user name was valid
    if ($TargetUser->Status() == U_OKAY)
    {
        # note that user was found
        $G_UserFound = TRUE;

        # attempt to confirm code
        $G_ResetCodeConfirmed = $TargetUser->IsResetCodeGood($ResetCode);
    }
}

# if new password was available from form
if (isset($_POST["F_Password"]) 
        && isset($_POST["F_PasswordAgain"]) 
        && (strlen(trim($_POST["F_Password"]))
                || strlen(trim($_POST["F_PasswordAgain"]))))
{
    # retrieve new password values
    $NewPassword = $_POST["F_Password"];
    $NewPasswordAgain = $_POST["F_PasswordAgain"];

    # if reset code was confirmed
    if ($G_ResetCodeConfirmed)
    {
        # if new passwords entered do not match
        if ($NewPassword != $NewPasswordAgain)
        {
            # set error message
            $G_ErrorMessage = "The two passwords you entered did not match.";
        }
        # else if new password is invalid
        elseif (!$TargetUser->IsValidPassword($NewPassword))
        {
            # set error message
            $G_ErrorMessage = "The password you entered was invalid.  Valid passwords must consist of numbers, letters, and punctuation marks (no spaces), and must be at least 6 characters in length.";
        }
        else
        {
            # set new password
            $TargetUser->SetPassword($NewPassword);
            $G_PasswordChanged = TRUE;
        }
    }
}

# make (safe version of) user name and reset code available for use in HTML
$G_UserName = strip_tags($UserName);
$G_ResetCode = strip_tags($ResetCode);

?>
