<?php
#
#   FILE:  SPT--SelectEditUserComplete.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2003 Internet Scout Project
#    ://scout.cs.wisc.edu
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# confirm remove user(s)
function ConfirmRemoveUsers()
{
    global $Session;

    $UserRemoveArray = array();

    reset($_POST);
    while (list($Var, $Value) = each ($_POST))
    {
        if (preg_match("/userid_([0-9]+)/", $Var))
        {
            if (isset($Value))
            {
                $UserRemoveArray[] = intval($Value);
            }
        }
    }
    $Session->PassVariable("UserRemoveArray", $UserRemoveArray);
    global $AF;
    $AF->SetJumpToPage("ConfirmRemoveUser");
}

# remove user(s)
function RemoveUsers()
{
    global $Session;
    global $AF;

    $DB = new Database();

    $UserRemoveArray = $Session->Get("UserRemoveArray");
    foreach ($UserRemoveArray as $UserId)
    {
        # don't let a user delete his or her own account
        if ($UserId == $GLOBALS["User"]->Id())
        {
            continue;
        }

        $RemoveUser = new User($DB, intval($UserId));
        $AF->SignalEvent("EVENT_USER_DELETED", array("UserId" => $RemoveUser->Id()));
        $RemoveUser->Delete();
    }
    global $AF;
    $AF->SetJumpToPage("UserList");
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $_POST;

if (!CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN)) {  return;  }

# grab entry information from database
$DB = new Database();

$Submit = $_POST["Submit"];

# check for Cancel button from previous screen
if ($Submit == "Cancel")
{
    $AF->SetJumpToPage("UserList");
}
else if (substr($Submit, 0, 6) == "Remove")
{
    # OK to remove selected user?
    if ($Session->Get("OkayToRemove"))
    {
        RemoveUsers();
    }
    # build array list of users to remove
    else
    {
        ConfirmRemoveUsers();
    }
}

?>
