<?PHP
#
#   FILE:  FieldRedactor.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

class FieldRedactor extends Plugin {

    function Register()
    {
        $this->Name = "Field Redactor";
        $this->Version = "1.0.1";
        $this->Description = "Allows values for a specified field to be"
                ." replaced with specified text when displayed, when user"
                ." is not logged in.";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
                "CWISCore" => "2.2.2");
        $this->EnabledByDefault = FALSE;

        $this->CfgSetup["FieldsToFilter"] = array(
                "Type" => "MetadataField",
                "Label" => "Field to Filter",
                "Help" => "Field to replace when being displayed.",
                "AllowMultiple" => TRUE
                );
        $this->CfgSetup["ReplacementText"] = array(
                "Type" => "Paragraph",
                "Label" => "Replacement Text",
                "Help" => "Text to display in place of field value.",
                "Columns" => 60,
                );
    }

    function Install()
    {
        $Schema = new MetadataSchema;
        $FieldId = $Schema->StdNameToFieldMapping("Url");
        if ($FieldId !== NULL)
        {
            $this->ConfigSetting("FieldsToFilter", array($FieldId));
            $this->ConfigSetting("ReplacementText",
                    "You must be logged in to access all resource information.");
        }
    }

    function HookEvents()
    {
        return array(
                "EVENT_FIELD_DISPLAY_FILTER" => "FilterValues",
                );
    }

    function FilterValues($Field, $Resource, $Value)
    {
        $FieldsToFilter = $this->ConfigSetting("FieldsToFilter");

        if (in_array($Field->Id(), $FieldsToFilter)
            && !$GLOBALS["G_User"]->IsLoggedIn()
            && $this->ShouldReplaceValue($Value))
        {
            $Value = $this->ConfigSetting("ReplacementText");
        }

        return array(
                "Field" => $Field,
                "Resource" => $Resource,
                "Value" => $Value);
    }

    /**
     * Determine if the value should be replaced. It shouldn't be replaced if
     * the value is empty or not set.
     * @param $Value value
     * @return TRUE if the value should be replaced or FALSE otherwise
     */
    protected function ShouldReplaceValue($Value)
    {
        # if a scalar and has a length
        if (is_scalar($Value) && strlen($Value) > 0)
        {
            return TRUE;
        }

        # not an empty array
        if (is_array($Value) && count($Value) > 0)
        {
            return TRUE;
        }

        # isn't null
        if (!is_null($Value))
        {
            return TRUE;
        }

        return FALSE;
    }

}
