<?php
/**
 * Set any extra include paths needed to use the library
 */
set_include_path(
    dirname(dirname(dirname(__FILE__))) . PATH_SEPARATOR .
    dirname(__FILE__)."/php-openid" . PATH_SEPARATOR .
    get_include_path()
);

require_once("config.php");
require_once('lib/AxisPHP/Axis--Database.php');
require_once('lib/AxisPHP/Axis--Session.php');
require_once('lib/AxisPHP/Axis--User.php');

Database::SetGlobalServerInfo($SPT_DBUserName, $SPT_DBPassword, $SPT_DBHost);
Database::SetGlobalDatabaseName($SPT_DBName);

global $DB, $Session;

$DB = new Database();

if ($DB->Query("SELECT Enabled FROM PluginInfo WHERE BaseName='OpenIdServer'","Enabled") !== "1")
{
    print("<h1>CWIS OpenID Server Endpoint</h1>");
    print("<p>This site is not configured to be an OpenId Provider</p>");
    exit(1);
}

# Pull in the php-openid components that I need.
require_once "OpenId_AxisDatabase.php" ;
require_once "OpenId_AxisDatabaseStore.php";

/**
 * Initialize an OpenID store
 *
 * @return object $store an instance of OpenID store (see the
 * documentation for how to create one)
 */
function getOpenIDStore()
{
    return new Auth_OpenID_AxisDatabaseStore(
        new Auth_OpenId_AxisDatabase(),
        "OpenIdServer_associations",
        "OpenIdServer_nonces"
        );
}

?>
