<?PHP
#
#   FILE:  ChangeFolderName.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

global $Folder;
global $Id;
global $Name;
global $ReturnTo;

PageTitle("Change Folder Name");

# make sure the user is logged in
if (!CheckAuthorization()) return;

# redirect if no folder ID is given
if (!isset($_GET["FolderId"]))
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}

try
{
    $FolderFactory = new Folders_FolderFactory($User->Id());
    $ResourceFolder = $FolderFactory->GetResourceFolder();
    $Folder = new Folders_Folder(GetArrayValue($_GET, "FolderId"));

    # redirect if the user should not see the folder
    if (!$ResourceFolder->ContainsItem($Folder->Id()))
    {
        $AF->SetJumpToPage("P_Folders_ManageFolders");
        return;
    }

    $Id = $Folder->Id();
    $Name = $Folder->Name();
    $ReturnTo = defaulthtmlentities(GetArrayValue($_GET, "ReturnTo"));
}

# redirect if given a bad folder ID
catch (Exception $Exception)
{
    $AF->SetJumpToPage("P_Folders_ManageFolders");
    return;
}
