<?PHP
#
#   FILE: EditTagsForm.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$AF->RequireUIFile("CW-Popup.js");

?>

<div class="tagging-wrapper" resourceid="<?PHP print $ResourceId; ?>" fieldid="<?PHP print $FieldId; ?>">
  <form method="post" action="index.php?P=P_Tags_EditTags">
    <input type="hidden" id="ReturnTo" name="ReturnTo" value="<?PHP print $ReturnTo; ?>" />
    <input type="hidden" id="ResourceId" name="ResourceId" value="<?PHP print $ResourceId; ?>" />
    <input type="hidden" id="Blacklist" name="Blacklist" value="<?PHP print $Blacklist; ?>" />

    <img class="tagging-help" src="<?PHP print $HelpImage; ?>" alt="Help" title='Add tags by entering them one per line in the text box or remove tags by deleting them from the text box. Click "Save Tags" when you are finished. Depending on the settings the web site administrator chose, you may not be able to remove some tags.' tooltip='Add tags by entering them one per line in the text box or remove tags by deleting them from the text box. Click "Save Tags" when you are finished. Depending on the settings the web site administrator chose, you may not be able to remove some tags.' />

    <textarea class="tagging-tagbox" id="Tags" name="Tags"><?PHP print $Tags; ?></textarea>

    <input class="tagging-savetags" type="submit" value="Save Tags" />
  </form>

  <div id="tagging-tooltip" class="cw-section cw-section-popup cw-section-tooltip cw-section-shadowed"></div>
  <script type="text/javascript">
    $(document).ready(function(){
      var Popup = cw.require("CW-Popup"),
          $tooltipNode = $("#tagging-tooltip"),
          $anchor = $("img.tagging-help"),
          tooltip = new Popup.Tooltip($tooltipNode);

      tooltip.anchor($anchor);
    });
  </script>
</div>
