<?PHP
#
#   FILE:  Report.php
#
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Reporting an URL in the URL Checker...");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$ResourceId = isset($_GET["ResourceId"]) ? intval($_GET["ResourceId"]) : NULL;
$FieldId = isset($_GET["FieldId"]) ? intval($_GET["FieldId"]) : NULL;
$Resource = new Resource($ResourceId);
$Schema = new MetadataSchema();
$Field = $Schema->GetField($FieldId);

if ($Resource->Status() == 1 && $Field->Status() == MetadataSchema::MDFSTAT_OK)
{
    if (isset($_POST["F_Note"]))
    {
        $AF->SignalEvent("URLCHECKER_REPORT_URL",
          array($Resource, $Field, $_POST["F_Note"]));
    }

    else
    {
       $AF->SignalEvent("URLCHECKER_REPORT_URL", array($Resource, $Field));
    }
}

$AF->SuppressHTMLOutput();
$AF->SetJumpToPage("index.php?P=P_UrlChecker_Results");
