<?PHP
#
#   FILE:  ActivateAccount.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2006-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("New Account Activation");

# ----- CONFIGURATION  -------------------------------------------------------

# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)

# ----- MAIN -----------------------------------------------------------------

# ensure the $UserName variable is declared
$UserName = NULL;

# retrieve user name and confirmation code from URL or form
if (isset($_GET["UN"]) && strlen(trim($_GET["UN"])))
{
    $UserName = $_GET["UN"];
}
elseif (isset($_POST["F_UserName"])
        && strlen(trim($_POST["F_UserName"])))
{
    $UserName = $_POST["F_UserName"];
}
if (isset($_GET["AC"]) && strlen(trim($_GET["AC"])))
{
    $ActivationCode = $_GET["AC"];
}
elseif (isset($_POST["F_ActivationCode"])
        && strlen(trim($_POST["F_ActivationCode"])))
{
    $ActivationCode = $_POST["F_ActivationCode"];
}

# assume that all checks/actions will fail
$G_UserFound = FALSE;
$G_AccountActivated = FALSE;
$G_AccountAlreadyActivated = FALSE;
$G_EmailChanged = FALSE;

# if user name and confirmation code found
if (isset($UserName) && isset($ActivationCode))
{
    # check user name
    $NewUser = new SPTUser($UserName);

    # if user name was valid
    if ($NewUser->Status() == U_OKAY)
    {
        # note that user was found
        $G_UserFound = TRUE;

        # if account is already activated
        if ($NewUser->IsActivated())
        {
            # note that account was already activated
            $G_AccountAlreadyActivated = TRUE;
            $OldEmail = $NewUser->Get("EMail");
            $NewEmail = $NewUser->Get("EMailNew");

            # Check if we're actually servicing a mail change request
            if ($NewUser->IsMailChangeCodeGood($ActivationCode) &&
                $OldEmail != $NewEmail )
            {
                $NewUser->Set("EMail", $NewEmail);
                $NewUser->Set("EMailNew", "");
                #Signal the email change
                $AF->SignalEvent("EVENT_USER_EMAIL_CHANGED", array(
                                     "UserId" => $NewUser->Id(),
                                     "OldEmail" => $OldEmail,
                                     "NewEmail" => $NewEmail));
                $G_EmailChanged = TRUE;
            }
        }
        else
        {
            # attempt to confirm code
            $G_AccountActivated = $NewUser->IsActivationCodeGood($ActivationCode);

            # if code was confirmed
            if ($G_AccountActivated)
            {
                # enable account for login
                $NewUser->RevokePriv(PRIV_USERDISABLED);
                $NewUser->IsActivated(TRUE);

                # signal that user has been activated
                $AF->SignalEvent("EVENT_USER_VERIFIED",
                        array("UserId" => $NewUser->Id()));
            }
        }
    }
}

# make (safe version of) user name available for use in HTML
$G_UserName = isset($UserName) ? strip_tags($UserName) : "";

?>
