<?PHP
#
#   FILE:  Feed.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();
$RSS = new RSS();

# set up some basic values
$StartingIndex = GetFormValue("SI", 0);
$EntriesPerPage = 25;
$SchemaId = $Blog->GetSchemaId();
$Entries = array();

# set up the RSS feed
$RSS->SetEncoding($GLOBALS["SysConfig"]->DefaultCharacterSet());
$RSS->SetLanguage("en-us");
$RSS->SetPublicationDate(date("Y-n-j"));
$RSS->AddChannel(
    $Blog->BlogName(),
    $GLOBALS["AF"]->BaseUrl(),
    $Blog->BlogDescription(),
    $GLOBALS["AF"]->BaseUrl()."index.php?P=P_Blog_RSS");

# get the blog entries
$Schema = new MetadataSchema($SchemaId);
$Factory = new ResourceFactory($SchemaId);
$PublicationField = $Schema->GetFieldByName(Blog::PUBLICATION_DATE_FIELD_NAME);
$DBFieldName = $PublicationField->DBFieldName();
$EntryIds = $Factory->GetItemIds(
    $DBFieldName." < '".date("Y-m-d H:i:s")."'",
    FALSE,
    $DBFieldName,
    FALSE);
$EntryCount = count($EntryIds);
$LastChangeTimestamp = strtotime($Blog->GetLatestPublicationDate());
$RSS->SetLastChangeDate(date("Y-m-d H:i:s", $LastChangeTimestamp));

# calculate ID array checksum and reset paging if list has changed
$ListChecksum = md5(serialize($EntryIds));
if ($ListChecksum != GetFormValue("CK")) {  $StartingIndex = 0;  }

# prune entry IDs down to just currently-selected segment
$EntryIds = array_slice($EntryIds, $StartingIndex, $EntriesPerPage);

# load blog entries from IDs
foreach ($EntryIds as $Id)
{
    $Entry = new Blog_Entry($Id);
    $Title = strip_tags($Entry->Title());
    $Body = strip_tags($Entry->Body());
    $Url = $GLOBALS["AF"]->BaseUrl()."index.php?P=P_Blog_Entry&EntryId=".$Id;
    $Date = $Entry->Get(Blog::PUBLICATION_DATE_FIELD_NAME);

    $RSS->AddItem($Title, $Url, $Body, $Date);
}

# suppress HTML output and publish RSS page
$AF->SuppressHTMLOutput();
$RSS->PrintRSS();
