<?PHP
#
#   FILE:  ConfirmDeleteClassification.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# print list of controlled names
function PrintClassification()
{
    global $Session, $Name, $InUseCount;

    $ClassId = $Session->Get("ClassId");
    $Session->PassVariable("ClassId", $ClassId);

    $Class = new Classification($ClassId);
    $Name = $Class->FullName();

    $InUseCount = $Class->ResourceCount();
    DisplayClassification();
}

# print actual value
function PrintClassificationInfo()
{
    global $Name, $InUseCount;

    if ($InUseCount > 0)
        print $Name." (This value in use by $InUseCount Resources)";
    else
        print $Name." (This value is not currently in use)";
}

# print list of children below this classification
function PrintChildrenClasses()
{
    global $Session;

    $ClassId = $Session->Get("ClassId");
    $Class = new Classification($ClassId);
    $ChildList = $Class->ChildList();
    foreach ($ChildList as $ChildId)
    {
        $ChildClass = new Classification($ChildId);
        print $ChildClass->FullName()."<br>";
    }
}

# determine if this classification has childern
function ClassHasChildren()
{
    global $Session;

    $ClassId = $Session->Get("ClassId");
    $Class = new Classification($ClassId);
    return $Class->ChildCount();
}

# print action value
function PrintAction()
{
    global $Action;

    print $Action;
}

# print target value
function PrintTarget()
{
    global $Target;

    print $Target;
}

# non-standard global variables
global $Action;
global $InUseCount;
global $Name;
global $Target;

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_NAMEADMIN)) {  return;  }

$Action = $_GET["action"];
$Target = $_GET["target"];

# pass FieldName through
$Session->PassVariable("FieldName", $Session->Get("FieldName"));

PageTitle("Confirm Delete $Action");

?>
