-- add metadata field table changes
ALTER TABLE MetadataFields ADD COLUMN Instructions TEXT;
ALTER TABLE MetadataFields ADD COLUMN NumAjaxResults INT DEFAULT 50;
ALTER TABLE MetadataFields ADD COLUMN UseWysiwygEditor INT DEFAULT 0;

-- Make the "Added By Id" field editable and only allow system administrators
-- to edit the field by default
UPDATE MetadataFields SET Editable = '1' WHERE FieldName = 'Added By Id';
UPDATE MetadataFields SET AuthoringPrivilege = '1' WHERE FieldName = 'Added By Id';
UPDATE MetadataFields SET EditingPrivilege = '1' WHERE FieldName = 'Added By Id';

-- Add some defaults to metadata fields
ALTER TABLE MetadataFields ALTER COLUMN PointPrecision SET DEFAULT 8;
ALTER TABLE MetadataFields ALTER COLUMN PointDecimalDigits SET DEFAULT 5;

-- Add a table for cached values
CREATE TABLE IF NOT EXISTS CachedValues (
    Name TEXT,
    Value TEXT,
    Updated TIMESTAMP
);

-- New columns for template file location caching in ApplicationFramework
ALTER TABLE ApplicationFrameworkSettings
        ADD COLUMN TemplateLocationCache TEXT;
ALTER TABLE ApplicationFrameworkSettings
        ADD COLUMN TemplateLocationCacheExpiration DATETIME;
ALTER TABLE ApplicationFrameworkSettings
        ADD COLUMN TemplateLocationCacheInterval INT DEFAULT 15;

-- add a column for when messages were last edited
ALTER TABLE Messages ADD COLUMN DateEdited DATETIME;
ALTER TABLE Messages ADD COLUMN EditorId INT;
