<?PHP

#
#   FILE:  OptionFormField.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

  /**
   * Generator for option form fields
   * \nosubgrouping
   */

class OptionFormField extends FormField {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /** @name Setup/Initialization */
    /*@{*/

    /**
     * Object constructor.
     * @param string $Name Internal name for this option, used for html id=
     * @param bool $IsRequired whether or not the field is required
     * @param string $Label Display label, shown to user in generated html
     * @param int $Length Maximum length allowed
     * @param array $Options Names of the options in this group
     * @param callback $ValidFunc Function to check the validity of this field
     * @param array $ValidMsgs Error messages associated with error codes from ValidFunc
     */
    function OptionFormField(
            $Name, $IsRequired, $Label, $Length, $Options,
            $ValidFunc = NULL, $ValidMsgs = NULL)
    {
        $this->MyLength = $Length;
        $this->MyOptions = $Options;

        $this->FormField($Name, $IsRequired, $Label, $ValidFunc, $ValidMsgs);
    }
    /*@}*/

    /** @name Accessors */
    /*@{*/

    /**
     * Get or set the length of the display field
     * @param int $NewVal (OPTIONAL)
     * @return Current length
     */
    function Length($NewVal = NULL) {  return $this->GetOrSet("MyLength", $NewVal);  }

    /**
     * Get or set the list of options displayed by this field
     * @param array $NewVal strings to use for option names (OPTIONAL)
     * @return Current list of options
     */
    function Options($NewVal = NULL) {  return $this->GetOrSet("MyOptions", $NewVal);  }

    /*@}*/

    /** @name Display */
    /*@{*/

    /**
     * Generate HTML representing this object
     * @param bool $DisplayErrorIndicator (OPTIONAL)
     */
    function PrintInput($DisplayErrorIndicator = FALSE)
    {
        print("<select name=\"".$this->MyName."\" size=\"".$this->MyLength."\">\n");
        foreach ($this->MyOptions as $OptionValue => $OptionLabel)
        {
            print("    <option value=\"".htmlspecialchars($OptionValue)."\""
                    .(($OptionValue == $this->Value()) ? " selected" : "")
                    .">".htmlspecialchars($OptionLabel)."\n");
        }
        print("</select>\n");
    }
    /*@}*/


    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $MyLength;
    private $MyOptions;
}

?>
