<?PHP
#
#   FILE:  UserCreator.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

/**
* Provide an 'Add User' button next to specified CWIS user fields.
*/
class UserCreator extends Plugin {

    /**
    * Register the UserCreator plugin.
    * @see Plugin::Register
    */
    function Register()
    {
        $this->Name = "User Creator";
        $this->Version = "1.0.2";
        $this->Description = "Creation of users ";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
            "CWISCore" => "2.3.2",
            "Mailer" => "1.0.0",
            );

        $this->CfgSetup["UserFields"] = array(
            "Type" => "MetadataField",
            "Default" => array(),
            "AllowMultiple" => TRUE,
            "FieldTypes" => MetadataSchema::MDFTYPE_USER,
            "Label" => "User fields for which an 'add' button should be displayed",
            "Help" => "Fields selected here will gain the 'add user' button on "
                      ."the edit screen",
            );
    }

    /**
    * Hook the UserCreator plugin into the event system.
    * @see Plugin::HookEvents
    */
    function HookEvents()
    {
        return array(
            "EVENT_APPEND_HTML_TO_FIELD_DISPLAY" => "AppendHtmlToFieldDisplay",
            );
    }

    /**
    * Inject the HTML to show the 'Add User' button.
    * See EVENT_APPEND_HTML_TO_FIELD_DISPLAY in @ref metadataevents "Metadata Events" for
    * details on the parameters and return values.
    */
    function AppendHtmlToFieldDisplay($Field, $Resource, $Context, $Html)
    {
        global $G_User;

        $MetadataFields = $this->ConfigSetting("UserFields");

        if ($MetadataFields !== NULL &&
            array_search($Field->Id(), $MetadataFields) !== FALSE &&
            $Context == "EDIT" &&
            $G_User->HasPriv(array(PRIV_USERADMIN, PRIV_SYSADMIN)) )
        {

            $Html .= '<a class="cw-button cw-button-elegant" '
                .'style="float:right" href="#" '.
                'onclick="window.open(\'index.php?P=P_UserCreator_NewUser'
                .'&ResourceId='.$Resource->Id().'\');" '
                .'>Add user</a>';
        }

        return array( "Field" => $Field,
                      "Resource" => $Resource,
                      "Context" => $Context,
                      "Html" => $Html );
    }
}
?>
