<?PHP
#
#   FILE:  Pages_PageFactory.php (Pages plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Edward Almasy and Internet Scout
#   http://scout.wisc.edu/cwis
#

/**
* Factory class for Page objects (from Pages plugin).
*/
class Pages_PageFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    function __construct()
    {
        # set up item factory base class
        $this->ItemFactory("Pages_Page", "Pages_Pages", "PageId", "PageTitle");
    }

    /**
    * Retrieve list of clean URLs for all pages.
    * @return Array with page indexes for index and clean URLs for values.
    */
    function GetCleanUrls()
    {
        $this->DB->Query("SELECT PageId, CleanUrl FROM Pages_Pages");
        $CleanUrls = $this->DB->FetchColumn("CleanUrl", "PageId");
        return $CleanUrls;
    }
}

