<?PHP

$GLOBALS["G_ErrMsg"] = Install_LoadDefaultConfig();

/**
* Load the default configuration for a new CWIS installation.
*/
function Install_LoadDefaultConfig()
{
    Install_LoadDefaultSystemConfiguration();
    Install_LoadDefaultAnnouncements();
    Install_LoadDefaultRSSConfiguration();
    Install_LoadDefaultFieldMappings();
    Install_LoadDefaultQualifierMappings();
    Install_LoadResourceCounts();
}

/**
* Load the default system configuration.
*/
function Install_LoadDefaultSystemConfiguration()
{
    # add a row for the system configuration
    $Database = new Database();
    $Database->Query("INSERT INTO SystemConfiguration VALUES ()");

    # update the system configuration
    $SysConfig = $GLOBALS["G_SysConfig"];
    $SysConfig->TopLinkString("");
    $SysConfig->PortalName("Online Resource Portal");
    $SysConfig->AdminEmail("webmaster@localhost");
    $SysConfig->NumClassesPerBrowsePage(80);
    $SysConfig->PasswordMailSubject("New Login for X-PORTALNAME-X (X-USERNAME-X)");
    $SysConfig->PasswordMailBody("\nThank you for signing up on X-PORTALNAME-X!\n\nTo activate your new login, please click on the link below:\n\n   X-ACTIVATIONURL-X\n\nIf the link doesn't work you can also go to this address:\n\n   X-MANUALACTIVATIONURL-X\n\nAnd enter your user name and activation code:\n\n   Name:  X-USERNAME-X\n   Code:  X-ACTIVATIONCODE-X\n\nWe're looking forward to seeing you online!");
    $SysConfig->PasswordResetMailSubject("X-PORTALNAME-X Password Change");
    $SysConfig->PasswordResetMailBody("Someone (presumably you) has asked to change your password on X-PORTALNAME-X for the account X-USERNAME-X.\n\nTo change your password, please click on this link:\n\n  X-RESETURL-X\n\nIf that link doesn't work you can also go to this address:\n\n   X-MANUALRESETURL-X\n\nAnd enter your user name and password reset code:\n\n   Name:  X-USERNAME-X\n   Code:  X-RESETCODE-X\n\nYour password will remain the same until changed via one of the above links.\n\n\nFor reference, the password change request came from address X-IPADDRESS-X and this e-mail was sent to X-EMAILADDRESS-X.");
    $SysConfig->MailChangeMailSubject("X-PORTALNAME-X mail address change request");
    $SysConfig->MailChangeMailBody("Someone (presumably you) has requested that the email address registered at X-PORTALNAME-X for the account X-USERNAME-X be changed from X-EMAILADDRESS-X to X-NEWEMAILADDRESS-X.\n\nTo confirm this change, please click on this link:\n\n  X-CHANGEURL-X\n\nIf that link doesn't work you can also go to this address:\n\n  X-MANUALCHANGEURL-X\n\nAnd enter your user name and confirmation code:\n\n   Name:  X-USERNAME-X\n\n   Code:  X-CHANGECODE-X\n\nIf you don't want to change your email, just ignore this message and nothing will be done.\n\nFor reference, the password change request came from address X-IPADDRESS-X and this e-mail was sent to X-NEWEMAILADDRESS-X");
    $SysConfig->SearchTermsRequired(1);
    $SysConfig->DefaultCharacterSet("UTF-8");
    $SysConfig->LegalNotice("Sample Content Copyright 1999-2013 Internet Scout");
    $SysConfig->DefaultActiveUI("default");
    $SysConfig->CurrentTheme("default");
    $SysConfig->DefaultUserPrivs(array(PRIV_POSTTOFORUMS, PRIV_POSTCOMMENTS));
}

/**
* Load the default announcements.
*/
function Install_LoadDefaultAnnouncements()
{
    $Database = new Database();
    $Database->Query("
        INSERT INTO Announcements SET
        `AnnouncementHeading` = 'Welcome',
        `AnnouncementText` = 'Welcome to your new online resource portal!  You may want to add some welcome text here.',
        `DatePosted` = NOW(),
        `PosterId` = '1'");
    $Database->Query("
        INSERT INTO Announcements SET
        `AnnouncementHeading` = 'News',
        `AnnouncementText` = 'News and announcements can also go in this area.',
        `DatePosted` = NOW(),
        `PosterId` = '1'");
}

/**
* Load the default RSS configuration.
*/
function Install_LoadDefaultRSSConfiguration()
{
    $Database = new Database();
    $Database->Query("
        INSERT INTO RSSConfiguration SET
        `EntriesToPublish` = '15',
        `ChannelTitle` = 'Online Resource Portal',
        `ChannelDescription` = 'Channel Description',
        `ImageUrl` = '',
        `ImageHeight` = '400',
        `ImageWidth` = '144',
        `ImageDescription` = 'Image Description',
        `Language` = 'en-us',
        `Copyright` = CONCAT('Copyright ', YEAR(NOW())),
        `ManagingEditor` = '',
        `Webmaster` = '',
        `PicsRating` = ''");
}

/**
* Load the default metadata field mappings.
*/
function Install_LoadDefaultFieldMappings()
{
    # the default field mappings to create
    $DefaultFieldMappings = array(
        array("Title", "nsdl_dc", "dc:title"),
        array("Alternate Title", "nsdl_dc", "dct:alternative"),
        array("Description", "oai_dc", "dc:description"),
        array("Description", "nsdl_dc", "dc:description"),
        array("Url", "oai_dc", "dc:identifier"),
        array("Url", "nsdl_dc", "dc:identifier"),
        array("Source", "oai_dc", "dc:source"),
        array("Source", "nsdl_dc", "dc:source"),
        array("Relation", "oai_dc", "dc:relation"),
        array("Relation", "nsdl_dc", "dc:relation"),
        array("Coverage", "oai_dc", "dc:coverage"),
        array("Coverage", "nsdl_dc", "dc:coverage"),
        array("Rights", "oai_dc", "dc:rights"),
        array("Rights", "nsdl_dc", "dc:rights"),
        array("Date Issued", "oai_dc", "dc:date"),
        array("Date Issued", "nsdl_dc", "dct:issued"),
        array("Publisher", "oai_dc", "dc:publisher"),
        array("Publisher", "nsdl_dc", "dc:publisher"),
        array("Creator", "oai_dc", "dc:creator"),
        array("Creator", "nsdl_dc", "dc:creator"),
        array("Contributor", "oai_dc", "dc:contributor"),
        array("Contributor", "nsdl_dc", "dc:contributor"),
        array("Subject", "oai_dc", "dc:subject"),
        array("Subject", "nsdl_dc", "dc:subject"),
        array("Resource Type", "oai_dc", "dc:type"),
        array("Resource Type", "nsdl_dc", "dc:type"),
        array("Language", "oai_dc", "dc:language"),
        array("Language", "nsdl_dc", "dc:language"),
        array("Audience", "nsdl_dc", "dct:audience"),
        array("Format", "oai_dc", "dc:format"),
        array("Format", "nsdl_dc", "dc:format"),
        array("Classification", "oai_dc", "dc:subject"),
        array("Classification", "nsdl_dc", "dc:subject"),
        array("Interactivity Type", "nsdl_dc", "ieee:interactivityType"),
        array("Interactivity Level", "nsdl_dc", "ieee:interactivityLevel"),
        array("Typical Learning Time", "nsdl_dc", "ieee:typicalLearningTime"),
        array("Table of Contents", "oai_dc", "dc:description"),
        array("Table of Contents", "nsdl_dc", "dct:tableOfContents"),
        array("Abstract", "oai_dc", "dc:description"),
        array("Abstract", "nsdl_dc", "dct:abstract"),
        array("Valid Date", "oai_dc", "dc:date"),
        array("Valid Date", "nsdl_dc", "dct:valid"),
        array("Modified Date", "oai_dc", "dc:date"),
        array("Modified Date", "nsdl_dc", "dct:modified"),
        array("Available Date", "oai_dc", "dc:date"),
        array("Available Date", "nsdl_dc", "dct:available"),
        array("Creation Date", "oai_dc", "dc:date"),
        array("Creation Date", "nsdl_dc", "dct:created"),
        array("Extent", "oai_dc", "dc:format"),
        array("Extent", "nsdl_dc", "dct:extent"),
        array("Medium", "oai_dc", "dc:format"),
        array("Medium", "nsdl_dc", "dct:medium"),
        array("Is Version Of", "oai_dc", "dc:relation"),
        array("Is Version Of", "nsdl_dc", "dct:isVersionOf"),
        array("Has Version", "oai_dc", "dc:relation"),
        array("Has Version", "nsdl_dc", "dct:hasVersion"),
        array("Is Replaced By", "oai_dc", "dc:relation"),
        array("Is Replaced By", "nsdl_dc", "dct:isReplacedBy"),
        array("Replaces", "oai_dc", "dc:relation"),
        array("Replaces", "nsdl_dc", "dct:replaces"),
        array("Is Required By", "oai_dc", "dc:relation"),
        array("Is Required By", "nsdl_dc", "dct:isRequiredBy"),
        array("Requires", "oai_dc", "dc:relation"),
        array("Requires", "nsdl_dc", "dct:requires"),
        array("Is Part Of", "oai_dc", "dc:relation"),
        array("Is Part Of", "nsdl_dc", "dct:isPartOf"),
        array("Has Part", "oai_dc", "dc:relation"),
        array("Has Part", "nsdl_dc", "dct:hasPart"),
        array("Is Referenced By", "oai_dc", "dc:relation"),
        array("Is Referenced By", "nsdl_dc", "dct:isReferencedBy"),
        array("References", "oai_dc", "dc:relation"),
        array("References", "nsdl_dc", "dct:references"),
        array("Is Format Of", "oai_dc", "dc:relation"),
        array("Is Format Of", "nsdl_dc", "dct:isFormatOf"),
        array("Has Format", "oai_dc", "dc:relation"),
        array("Has Format", "nsdl_dc", "dct:hasFormat"),
        array("Conforms To", "oai_dc", "dc:relation"),
        array("Conforms To", "nsdl_dc", "dct:conformsTo"),
        array("Spatial", "oai_dc", "dc:coverage"),
        array("Spatial", "nsdl_dc", "dct:spatial"),
        array("Temporal", "oai_dc", "dc:coverage"),
        array("Temporal", "nsdl_dc", "dct:temporal"),
        array("Mediator", "oai_dc", "dc:type"),
        array("Mediator", "nsdl_dc", "dct:mediator"),
        array("Date Accepted", "oai_dc", "dc:date"),
        array("Date Accepted", "nsdl_dc", "dct:dateAccepted"),
        array("Date Copyrighted", "oai_dc", "dc:date"),
        array("Date Copyrighted", "nsdl_dc", "dct:dateCopyrighted"),
        array("Date Submitted", "oai_dc", "dc:date"),
        array("Date Submitted", "nsdl_dc", "dct:dateSubmitted"),
        array("Education Level", "nsdl_dc", "dct:educationLevel"),
        array("Access Rights", "oai_dc", "dc:rights"),
        array("Access Rights", "nsdl_dc", "dct:accessRights"),
        array("Bibliographic Citation", "oai_dc", "dc:identifier"),
        array("Bibliographic Citation", "nsdl_dc", "dct:bibliographicCitation"));

    $Database = new Database();
    $Schema = new MetadataSchema();

    # create each default field mapping
    foreach ($DefaultFieldMappings as $DefaultFieldMapping)
    {
        list($FieldName, $FormatName, $OAIFieldName) = $DefaultFieldMapping;

        # get the field object from its name
        $Field = $Schema->GetFieldByName($FieldName);

        # only create the mapping if the field is valid
        if ($Field instanceof MetadataField)
        {
            $Database->Query("
                INSERT INTO OAIFieldMappings SET
                `FormatName` = '".addslashes($FormatName)."',
                `SPTFieldId` = '".intval($Field->Id())."',
                `OAIFieldName` = '".addslashes($OAIFieldName)."'");
        }
    }
}

/**
* Load the default qualifier mappings.
*/
function Install_LoadDefaultQualifierMappings()
{
    # the default qualifier mappings to create
    $DefaultQualifierMappings = array(
        array("DCMI Box", "nsdl_dc", "dct:Box"),
        array("DCMI Period", "nsdl_dc", "dct:Period"),
        array("DCMI Point", "nsdl_dc", "dct:Point"),
        array("DCMI Type Vocabulary", "nsdl_dc", "dct:DCMIType"),
        array("DDC", "nsdl_dc", "dct:DDC"),
        array("IMT", "nsdl_dc", "dct:IMT"),
        array("ISO 3166", "nsdl_dc", "dct:ISO3166"),
        array("ISO 639-2", "nsdl_dc", "dct:ISO639-2"),
        array("LCC", "nsdl_dc", "dct:LCC"),
        array("LCSH", "nsdl_dc", "dct:LCSH"),
        array("MeSH", "nsdl_dc", "dct:MESH"),
        array("RFC 1766", "nsdl_dc", "dct:RFC1766"),
        array("RFC 3066", "nsdl_dc", "dct:RFC3066"),
        array("TGN", "nsdl_dc", "dct:TGN"),
        array("UDC", "nsdl_dc", "dct:UDC"),
        array("URI", "nsdl_dc", "dct:URI"),
        array("W3C-DTF", "nsdl_dc", "dct:W3CDTF"));

    $Database = new Database();
    $QualifierFactory = new QualifierFactory();

    # create each default qualifier mapping
    foreach ($DefaultQualifierMappings as $DefaultQualifierMapping)
    {
        list($QualifierName, $FormatName, $OAIQualifierName) = $DefaultQualifierMapping;

        # get the qualifier object from its name
        $Qualifier = $QualifierFactory->GetItemByName($QualifierName);

        # only create the mapping if the qualifier is valid
        if ($Qualifier instanceof Qualifier)
        {
            $Database->Query("
                INSERT INTO OAIQualifierMappings SET
                `FormatName` = '".addslashes($FormatName)."',
                `SPTQualifierId` = '".intval($Qualifier->Id())."',
                `OAIQualifierName` = '".addslashes($OAIQualifierName)."'");
        }
    }
}

/**
* Load the resource counts.
*/
function Install_LoadResourceCounts()
{
    $ResourceFactory = new ResourceFactory();
    $ResourceFactory->UpdateResourceCountCallback();
}
