<?PHP
#
#   FILE:  AddClassificationComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------


# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------


# check if current user is authorized
if (!CheckAuthorization(PRIV_CLASSADMIN)) {  return;  }

# clear any old error info
if (isset($ErrorMessages))
{
    unset($ErrorMessages);
    $Session->UnregisterVariable("ErrorMessages");
}

$Submit = $_POST["Submit"];
$F_FieldId = $_POST["F_FieldId"];
$F_ParentId = $_POST["F_ParentId"];
$F_NewSegmentName = $_POST["F_NewSegmentName"];

if (isset($_POST["F_QualifierId"]))
    $F_QualifierId = $_POST["F_QualifierId"];
else
    $F_QualifierId = NULL;

if (is_null($F_QualifierId) || $F_QualifierId == "--")
    $F_QualifierId = "NULL";

# if add classification was requested
if ($Submit != "Cancel")
{
    # if new classification segment name is valid
    $F_NewSegmentName = trim($F_NewSegmentName);
    if (strlen($F_NewSegmentName) > 0)
    {
        # add new classification
        $Class = new Classification(NULL,
                $F_NewSegmentName, $F_FieldId, $F_ParentId);

        # if classification creation succeeded
        if ($Class->Status() == Classification::CLASSSTAT_OK)
        {
            # add qualifier ID (if any)
            if (isset($F_QualifierId) && strlen($F_QualifierId))
            {
                $Class->QualifierId($F_QualifierId);
            }
        }
        else
        {
            # set appropriate error message
            $ErrorMessages = new ErrorList();
            switch ($Class->Status())
            {
                case Classification::CLASSSTAT_DUPLICATENAME:
                    $ErrorMessages->AddMessage(
                            "A classification with that name already exists.");
                    break;

                default:
                    $ErrorMessages->AddMessage(
                            "An unknown error has occurred when trying to add"
                            ." the classification.  (".$Class->Status().")");
                    break;
            }
        }
    }
    else
    {
        # add message to error list
        $ErrorMessages = new ErrorList();
        $ErrorMessages->AddMessage(
                "No classification segment name was supplied.");
    }
}

# if errors were found
if (isset($ErrorMessages))
{
    # return to editing page with error messages
    $Session->RegisterVariable("ErrorMessages",$ErrorMessages);
    $AF->SetJumpToPage("AddClassification&ParentId=".$F_ParentId
                    ."&FieldId=".$F_FieldId);
}
else
{
    # go to classification selection page for parent of edited classification
    $AF->SetJumpToPage("EditClassifications&FieldId=".$F_FieldId
                       ."&ParentId=".$F_ParentId);
}
