<?PHP
#
#   FILE:  AssignControlledName.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# process selected controlled names
function ProcessSelectedControlledNames()
{
    global $ResourceId;

    $Schema = new MetadataSchema();

    reset($_POST);
    while (list($Var, $Value) = each ($_POST))
    {
        if (ereg("cn_([0-9]+)", $Var, $Regs) )
        {
            $Value = trim($Value);
            if ($Value != "")
            {
                $ControlledName = $Value;
                continue;
            }
        }
        if (ereg("cnid_([0-9]+)", $Var, $Regs) )
        {
            $Value = trim($Value);
            if ($Value != "")
            {
                $ControlledNameId = $Value;
                $CN = new ControlledName($ControlledNameId);
                $Field = $Schema->GetField($CN->FieldId());
                $Resource = new Resource($ResourceId);
                $Resource->Set($Field->Name(), $ControlledNameId);
            }
        }
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $ResourceId;

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN)) {  return;  }

# get currently edited resource
$RFactory = new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

ProcessSelectedControlledNames();

# return to the DB Entry page
$Link = "index.php?P=DBEntry&amp;ResourceId=".$ResourceId;
$AF->SetJumpToPage($Link);
