<?PHP
#
#   FILE:  EditAnnouncment.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function AnnouncementInfoAvailable()
{
    global $AnnouncementHeading;
    return (isset($AnnouncementHeading)) ? TRUE : FALSE;
}

function EditingAnnouncement()
{
    global $F_Editing;
    return (isset($F_Editing)) ? TRUE : FALSE;
}

function PrintAnnouncementHeading()
{
    global $AnnouncementHeading;

    print defaulthtmlentities($AnnouncementHeading);
}

function PrintAnnouncementText()
{
    global $AnnouncementText;

    print defaulthtmlentities($AnnouncementText);
}

function PreviewAnnouncementHeading()
{
    global $AnnouncementHeading;
    print defaulthtmlentities($AnnouncementHeading);
}

function PreviewAnnouncementText()
{
    global $AnnouncementText;
    print nl2br(StripXSSThreats($AnnouncementText));
}

function PrintAnnouncementDate()
{
    print date("M j");
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function LoadAnnouncement($Id)
{
    global $DB;
    global $Session;
    global $AnnouncementHeading, $AnnouncementText;

    # retrieve announcement values
    if (isset($Id) && (!isset($AnnouncementHeading)))
    {
        $DB->Query("SELECT * FROM Announcements WHERE AnnouncementId=".intval($Id));
        $Announcement = $DB->FetchRow();
        $AnnouncementHeading = $Announcement["AnnouncementHeading"];
        $AnnouncementText = $Announcement["AnnouncementText"];
    }

    # remember announcement ID
    $Session->PassVariable("F_Id", $Id);
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $AnnouncementHeading;
global $AnnouncementText;
global $F_Editing;

if (isset($_GET["F_Id"]))
    $F_Id = intval($_GET["F_Id"]);
else
    $F_Id = $Session->Get("F_Id");

if (isset($_GET["F_Editing"]))
    $F_Editing = $_GET["F_Editing"];
else
    $F_Editing = $Session->Get("F_Editing");

# set page title based on whether an announcement ID was passed in
if (isset($F_Editing))
    PageTitle("Edit Announcement");
else
    PageTitle("Add Announcement");

# load announcement info
LoadAnnouncement($F_Id);

# pass along editing flag if set
if (isset($F_Editing)) {  $Session->PassVariable("F_Editing", $F_Editing);  }
if (!CheckAuthorization( PRIV_NEWSADMIN )) {  return;  }

?>
