<?PHP
#
#   FILE:  FullImage.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

$FieldName = isset($_GET["FieldName"]) ? $_GET["FieldName"] : NULL;
PageTitle($FieldName." Display");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print field name
function PrintFieldName()
{
    global $FieldName;

    print $FieldName;
}

# print Resource Title
function PrintResourceTitle()
{
    global $ResourceTitle;

    print $ResourceTitle;
}

# print Url
function PrintUrl()
{
    global $Url;

    print $Url;
}

# print Record Link
function PrintRecordLink()
{
    global $RecordLink;

    print $RecordLink;
}

# print Return Page
function PrintReturnPage()
{
    global $ReturnPage;

    print $ReturnPage;
}

# print Height
function PrintHeight()
{
    global $Height;

    print $Height;
}

# print Width
function PrintWidth()
{
    global $Width;

    print $Width;
}

# print AltText
function PrintAltText()
{
    global $AltText;

    print $AltText;
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $AltText;
global $FieldName;
global $Height;
global $RecordLink;
global $ResourceTitle;
global $ReturnPage;
global $Url;
global $Width;

$Schema = new MetadataSchema();
$TitleField = $Schema->GetFieldByMappedName("Title");

if (!isset($_GET["ResourceId"]) || (!isset($_GET["FieldName"]) && !isset($_GET["FI"])))
{
    $AF->SetJumpToPage("Home");
}
else
{
    $Resource = new Resource($_GET["ResourceId"]);
    if ($Resource->Status() == -1)
    {
        $AF->SetJumpToPage("Home");
    }
    else
    {
        $ResourceTitle = $Resource->UserCanViewField($User, $TitleField)
                ? $Resource->Get($TitleField) : "";
        if (array_key_exists("FI", $_GET))
        {
            $Field = $Schema->GetField($_GET["FI"]);
        }
        else
        {
            $Field = $Schema->GetFieldByName($_GET["FieldName"]);
        }
        if ($Field == NULL)
        {
            $AF->SetJumpToPage("Home");
        }
        else
        {
            $ImageId = GetFormValue("ID");
            if ($ImageId == NULL)
            {
                $AF->SetJumpToPage("Home");
            }
            else
            {
                $SPTImage = new SPTImage($ImageId);
                $Width = $SPTImage->Width();
                $Height = $SPTImage->Height();
                $Url = $SPTImage->Url();
                $AltText = $SPTImage->AltText();
                $CanPreview = $Field->Enabled() && (($Field->ImagePreviewPrivilege() == 0)
                        || $User->HasPriv($Field->ImagePreviewPrivilege())
                        || $Resource->UserCanEditField($User, $Field));

                if (!$Resource->UserCanViewField($User, $Field) || !$CanPreview)
                {
                    if (isset($_GET["edit"]) && $_GET["edit"] == 1)
                    {
                        $AF->SetJumpToPage("index.php?P=EditResource&amp;ID="
                                .$Resource->Id());
                    }
                    else
                    {
                        $AF->SetJumpToPage("index.php?P=FullRecord&amp;ID="
                                .$Resource->Id());
                    }
                }

                # return to metadata tool
                if (isset($_GET["edit"]))
                {
                    $RecordLink = "index.php?P=EditResource&amp;ID=".$Resource->Id();
                    $ReturnPage = "Edit Resource for ";
                }
                # return to full record
                else
                {
                    $RecordLink = "index.php?P=FullRecord&amp;ID=".$Resource->Id();
                    $ReturnPage = "Full Record for ";
                }
            }
        }
    }
}


