<?PHP
#
#   FILE:  UserLogout.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2002-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# if user is currently logged in
if ($User->IsLoggedIn() == TRUE)
{
    # wipe out editing state values
    $Schema = new MetadataSchema();
    while ($Schema->GetCurrentEditedItemId()) {  $Schema->ClearCurrentEditedItem();  }
    $RFactory = new ResourceFactory();
    while ($RFactory->GetCurrentEditedItemId()) {  $RFactory->ClearCurrentEditedItem();  }

    # signal user logout
    $AF->SignalEvent("EVENT_USER_LOGOUT", array("UserId" => $User->Id()));

    # log user out
    $User->Logout();
}

# return to page where user logged out
$ReturnPage = isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : "Home";

# pass logout return address through any hooked filters via signal
$SignalResult = $AF->SignalEvent("EVENT_USER_LOGOUT_RETURN",
        array("ReturnPage" => $ReturnPage));
$ReturnPage = $SignalResult["ReturnPage"];

# set destination to return to after logout
$AF->SetJumpToPage($ReturnPage);

?>
