<?PHP
#
#   FILE:  BackwardCompatibility.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Plugin to add measures of backward compatibility with 1.x versions of CWIS.
*/
class BackwardCompatibility extends Plugin {

    # ---- STANDARD PLUGIN INTERFACE -----------------------------------------

    /**
    * Set plugin attributes.
    */
    function Register()
    {
        $this->Name = "Backward Compatibility";
        $this->Version = "1.0.2";
        $this->Description = "Improves backwards compatibility with older"
                ." versions of CWIS";
        $this->Author = "Internet Scout";
        $this->Url = "http://scout.wisc.edu/cwis/";
        $this->Email = "scout@scout.wisc.edu";
        $this->Requires = array(
                "CWISCore" => "2.3.2");
        $this->EnabledByDefault = FALSE;
    }

    /**
    * Initialize the plugin.  This is called after all plugins have been loaded
    * but before any methods for this plugin (other than Register() or Initialize())
    * have been called.
    * @return NULL if initialization was successful, otherwise a string containing
    *       an error message indicating why initialization failed.
    */
    function Initialize()
    {
        # set up old configuration references
        $GLOBALS["SPT_DBUserName"] = $GLOBALS["G_Config"]["Database"]["UserName"];
        $GLOBALS["SPT_DBPassword"] = $GLOBALS["G_Config"]["Database"]["Password"];
        $GLOBALS["SPT_DBHost"] =     $GLOBALS["G_Config"]["Database"]["Host"];
        $GLOBALS["SPT_DBName"] =     $GLOBALS["G_Config"]["Database"]["DatabaseName"];
        $GLOBALS["SPT_DBName"] =     $GLOBALS["G_Config"]["UserInterface"]["DefaultUI"];

        # set up possible old UI directories and file names to be included
        #       when searching for UI files
        $GLOBALS["AF"]->AddIncludeDirectories(array(
                "local/interface/%ACTIVEUI%/include/SPT--",
                "local/interface/SPT--%ACTIVEUI%/include/SPT--",
                "interface/%ACTIVEUI%/include/SPT--",
                "SPTUI--%ACTIVEUI%/include/",
                "SPTUI--%ACTIVEUI%/include/SPT--",
                "%ACTIVEUI%/include/",
                "%ACTIVEUI%/include/SPT--",
                "local/interface/default/include/SPT--",
                "interface/default/include/SPT--",
                ), TRUE, TRUE);
        $GLOBALS["AF"]->AddInterfaceDirectories(array(
                "local/interface/%ACTIVEUI%/SPT--",
                "local/interface/SPT--%ACTIVEUI%/SPT--",
                "interface/%ACTIVEUI%/SPT--",
                "SPTUI--%ACTIVEUI%/",
                "SPTUI--%ACTIVEUI%/SPT--",
                "%ACTIVEUI%/",
                "%ACTIVEUI%/SPT--",
                "local/interface/default/SPT--",
                "interface/default/SPT--",
                ), TRUE, TRUE);
        $GLOBALS["AF"]->AddImageDirectories(array(
                "local/interface/SPT--%ACTIVEUI%/images/",
                "SPTUI--%ACTIVEUI%/images/",
                "%ACTIVEUI%/images/",
                ), TRUE, TRUE);
        $GLOBALS["AF"]->AddFunctionDirectories(array(
                "local/interface/SPT--%ACTIVEUI%/include/",
                "SPTUI--%ACTIVEUI%/include/",
                "%ACTIVEUI%/include/",
                ), TRUE, TRUE);

        # create links to files possibly referenced in old (pre-2.0) code.
        $this->CreateCompatabilityLinks();

        # report that initialization was successful
        return NULL;
    }

    /**
    * Create links to files possibly referenced in old (pre-2.0) code.
    */
    private function CreateCompatabilityLinks()
    {
        $NeededFiles = array(
                "include/SPT--Classification.php",
                "include/SPT--Common.php",
                "include/SPT--ControlledName.php",
                "include/SPT--ControlledNameFactory.php",
                "include/SPT--ItemFactory.php",
                "include/SPT--MetadataSchema.php",
                "include/SPT--Resource.php",
                "include/SPT--SavedSearch.php",
                "include/SPT--SearchEngine.php",
                "include/SPT--SPTDatabase.php",
                "include/SPT--SPTEventLog.php",
                "include/SPT--SPTImage.php",
                "include/SPT--SPTUser.php",
                "include/DummyFile.php",
                "Axis--User.php",
                "Axis--Date.php",
                "Axis--Session.php",
                );
        $NeededLinks = array(
                "SPTUI--CWIS" => "interface/default",
                );
        foreach ($NeededFiles as $FileName)
        {
            if (!file_exists($FileName)) {  touch($FileName);  }
        }
        foreach ($NeededLinks as $Source => $Destination)
        {
            if (!file_exists($Source)) {  symlink($Destination, $Source);  }
        }
    }

}


