<?PHP
#
#   FILE:  UpdateFolderName.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

# check authorization and setup HTML suppression and page redirection
if (!Folders_Common::ApiPageCompletion("P_Folders_ManageFolders")) return;

# canceled editing
if (GetArrayValue($_GET, "Cancel"))
{
    return;
}

$FolderId = GetArrayValue($_GET, "FolderId");
$FolderName = GetArrayValue($_GET, "FolderName");

# can't do anything if there isn't a folder ID or name to work with
if (!strlen($FolderId) || !strlen($FolderName))
{
    return;
}

try
{
    $FolderFactory = new Folders_FolderFactory($User->Id());
    $ResourceFolder = $FolderFactory->GetResourceFolder();
    $Folder = new Folders_Folder($FolderId);

    # withdraw only if the resource folder contains this folder, which implies
    # that the user owns the folder and it's a valid folder of resources
    if ($ResourceFolder->ContainsItem($Folder->Id()))
    {
        $Folder->Name($FolderName);
    }
} catch (Exception $Exception) {}
