<?php
#
#   FILE:  OpenId_AxisDatabaseStore.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Edward Almasy and Internet Scout
#   http://scout.wisc.edu
#

# NOTE:
#
# The php-openid library has its own database abstraction system.
# To hook a new DB into it, one must implement an object following their specification.
# This class is created only for use with php-openid, and SHOULD NOT
# be used in other code.  Use the Database() class instead.

# Don't include in CWIS developer documentation, since this is just a shim to talk to
# an external library.
/** \cond */

# Require the base class file.
require_once "Auth/OpenID/SQLStore.php";

/**
* An SQL store for php-openid that uses an Axis--Database as its backend.
*/
class Auth_OpenID_AxisDatabaseStore extends Auth_OpenID_SQLStore {

    /**
    * Set up the queries that OpenID will use.
    */
    function setSQL()
    {
        $this->sql['nonce_table'] =
            "CREATE TABLE %s (\n".
            "  server_url VARCHAR(2047) NOT NULL,\n".
            "  timestamp INTEGER NOT NULL,\n".
            "  salt CHAR(40) NOT NULL,\n".
            "  UNIQUE (server_url(255), timestamp, salt)\n".
            ")";

        # set the default character set to latin1 so that the multi-byte primary
        # keys will be less than 1000 bytes, a requirement for some servers
        # keep in mind that this might be an issue for URLs that require UTF-8,
        # though, at this point, there are very few that do
        $this->sql['assoc_table'] =
            "CREATE TABLE %s (\n".
            "  server_url BLOB NOT NULL,\n".
            "  handle VARCHAR(255) NOT NULL,\n".
            "  secret BLOB NOT NULL,\n".
            "  issued INTEGER NOT NULL,\n".
            "  lifetime INTEGER NOT NULL,\n".
            "  assoc_type VARCHAR(64) NOT NULL,\n".
            "  PRIMARY KEY (server_url(255), handle)\n".
            ") default charset=latin1";

        $this->sql['set_assoc'] =
            "REPLACE INTO %s (server_url, handle, secret, issued,\n".
            "  lifetime, assoc_type) VALUES (?, ?, !, ?, ?, ?)";

        $this->sql['get_assocs'] =
            "SELECT handle, secret, issued, lifetime, assoc_type FROM %s ".
            "WHERE server_url = ?";

        $this->sql['get_assoc'] =
            "SELECT handle, secret, issued, lifetime, assoc_type FROM %s ".
            "WHERE server_url = ? AND handle = ?";

        $this->sql['remove_assoc'] =
            "DELETE FROM %s WHERE server_url = ? AND handle = ?";

        $this->sql['add_nonce'] =
            "INSERT INTO %s (server_url, timestamp, salt) VALUES (?, ?, ?)";

        $this->sql['clean_nonce'] =
            "DELETE FROM %s WHERE timestamp < ?";

        $this->sql['clean_assoc'] =
            "DELETE FROM %s WHERE issued + lifetime < ?";
    }

    /**
    * Encode binary data.
    */
    function blobEncode($blob)
    {
        return "0x" . bin2hex($blob);
    }

    /**
    * Determine if an error occurred.
    */
    function isError($value)
    {
        return $value === FALSE;
    }
}

/** \endcond */
?>
