<?PHP
#
#   FILE: EditTagsForm.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

$GLOBALS["AF"]->RequireUIFile("CW-Popup.js");
$GLOBALS["AF"]->RequireUIFile("CW-Keyboard.js");
$GLOBALS["AF"]->RequireUIFile("CW-QuickSearch.js");

$SafeResourceId = defaulthtmlentities($ResourceId);
$SafeFieldId = defaulthtmlentities($FieldId);

?>

<noscript>
  <form method="post" action="index.php?P=P_Tags_EditTags">
    <div class="tags-simple_interface">
      <input type="hidden" id="ReturnTo" name="ReturnTo" value="<?PHP print $ReturnTo; ?>" />
      <input type="hidden" id="ResourceId" name="ResourceId" value="<?PHP print $ResourceId; ?>" />

      <img class="tags-help"
           src="<?PHP print $HelpImage; ?>"
           alt="Help"
           title='Add tags by entering them one per line in the text box or remove tags by deleting them from the text box. Click "Save Tags" when you are finished. Depending on the settings the web site administrator chose, you may not be able to remove some tags.' />

      <textarea class="tags-tagbox" id="Tags" name="Tags"><?PHP print $Tags; ?></textarea>

      <input class="tags-save_tags" type="submit" value="Save Tags" />
    </div>
  </form>
</noscript>

<div class="tags-rich_interface">
  <div class="tags-editable_tags"><?PHP print $Tags; ?></div>
  <div class="tags-blacklist"><?PHP print $Blacklist; ?></div>
  <input class="tags-tag_input"
         type="text"
         data-fieldid="<?PHP print $SafeFieldId; ?>"
         data-resourceid="<?PHP print $SafeResourceId; ?>" />
  <img class="tags-help" src="<?PHP print $HelpImage; ?>" alt="Help"
       title="Type to begin searching for tags. Tags that are similiar to what you type will be displayed along with an option to create a new tag if one doesn&#39;t exist for what you type. Remove a tag by clicking the &quot;X&quot; next to the tag you wish to remove. Depending on the settings the web site administrator chose, you may not be able to remove some tags."
       data-tooltip="Type to begin searching for tags. Tags that are similiar to what you type will be displayed along with an option to create a new tag if one doesn&#39;t exist for what you type. Remove a tag by clicking the &quot;X&quot; next to the tag you wish to remove. Depending on the settings the web site administrator chose, you may not be able to remove some tags." />
</div>

<div id="tags-tooltip" class="cw-section cw-section-popup cw-section-tooltip cw-section-shadowed"></div>
<script type="text/javascript">
  jQuery(document).ready(function(){
    var Tags = cw.require("Tags"),
        Popup = cw.require("CW-Popup"),
        tagsQuickSearch = new Tags.FullRecordTagsQuickSearch(),
        tooltip = new Popup.Tooltip(jQuery("#tags-tooltip")),
        input = jQuery(".tags-tag_input");

    // add a tooltip to the help icon
    tooltip.anchor(jQuery(".tags-rich_interface .tags-help"));

    // show the rich interface
    jQuery(".tags-rich_interface").show();

    // set the basic options of the quicksearch box
    tagsQuickSearch.addTriggerElements(input);
    tagsQuickSearch.setFieldId(input.attr("data-fieldid"));
    tagsQuickSearch.setResourceId(input.attr("data-resourceid"));
    tagsQuickSearch.setMaxNumSearchResults(10);

    // finish setting it up. tagsQuickSearch.setEditableTags() needs to be
    // called before tagsQuickSearch.setTagList(...)
    tagsQuickSearch.setEditableTags(jQuery(".tags-editable_tags"));
    tagsQuickSearch.setBlacklist(jQuery(".tags-blacklist"));
    tagsQuickSearch.setTagList(jQuery(".tags-rich_interface").siblings("ul:first-child"));
  });
</script>
