<?PHP
#
#   FILE:  AddTopic.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (!CheckAuthorization(PRIV_POSTTOFORUMS, PRIV_FORUMADMIN, PRIV_SYSADMIN)) {  return;  }

if (isset($_SESSION["ErrorMessages"]))
    $H_ErrorMessages = GetFromSession("ErrorMessages");

if (!isset($_GET["FI"]))
    $H_ErrorMessages []= "No ForumId provided";

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

function GetFromSession($VarName){
    $Value = NULL;
    if (isset($_SESSION[$VarName]))
    {
        $Value = $_SESSION[$VarName];
        unset ($_SESSION[$VarName]);
    }
    return $Value;
}

# ----- MAIN -----------------------------------------------------------------

$H_Forum = new Forum( intval($_GET["FI"]) );

if (isset($_POST["F_TopicName"]))
    $H_TopicName = $_POST["F_TopicName"];
elseif (isset($_SESSION["TopicName"]))
    $H_TopicName = GetFromSession("TopicName");
else
    $H_TopicName = "";

if (isset($_POST["F_Subject"]))
    $H_Subject = $_POST["F_Subject"];
elseif (isset($_SESSION["Subject"]))
    $H_Subject = GetFromSession("Subject");
else
    $H_Subject = "";

if (isset($_POST["F_Body"]))
    $H_Body = $_POST["F_Body"];
elseif (isset($_SESSION["Body"]))
    $H_Body = GetFromSession("Body");
else
    $H_Body = "";

PageTitle("Add Topic");
