<?PHP
#
#   FILE:  EditPasswordMail.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2006-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- CONFIGURATION  -------------------------------------------------------

PageTitle("Edit Password E-Mail Text");
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }


# ----- EXPORTED FUNCTIONS ---------------------------------------------------
# (functions intended for use in corresponding HTML file)

# ----- LOCAL FUNCTIONS ------------------------------------------------------
# (functions intended for use only within this file)


# ----- MAIN -----------------------------------------------------------------

# clear error flags
$G_ErrorWithResetBody = FALSE;
$G_ErrorWithActivationBody = FALSE;
$G_ErrorWithChangeBody = FALSE;
$G_EditingComplete = FALSE;

# if we have values from a submitted form
if (isset($_POST["Submit"]))
{
    # if user requested to cancel editing
    if ($_POST["Submit"] == "Cancel")
    {
        # return to administration menu
        $AF->SetJumpToPage("SysAdmin");
        return;
    }
    else
    {
        # retrieve values from form
        $G_ActivationSubject = @$_POST["F_ActivationSubject"];
        $G_ActivationBody = @$_POST["F_ActivationBody"];
        $G_ResetSubject = @$_POST["F_ResetSubject"];
        $G_ResetBody = @$_POST["F_ResetBody"];
        $G_ChangeSubject = @$_POST["F_ChangeSubject"];
        $G_ChangeBody = @$_POST["F_ChangeBody"];

        # if account activation e-mail body is invalid
        if ((substr_count($G_ActivationBody, "X-ACTIVATIONURL-X") == 0)
                && (substr_count($G_ActivationBody, "X-ACTIVATIONPARAMETERS-X") == 0)
                && ((substr_count($G_ActivationBody, "X-MANUALACTIVATIONURL-X") == 0)
                    || (substr_count($G_ActivationBody, "X-USERNAME-X") == 0)
                    || (substr_count($G_ActivationBody, "X-ACTIVATIONCODE-X") == 0)))
        {
            # set error flag
            $G_ErrorWithActivationBody = TRUE;
        }

        # if password reset e-mail body is invalid
        if ((substr_count($G_ResetBody, "X-RESETURL-X") == 0)
                && (substr_count($G_ResetBody, "X-RESETPARAMETERS-X") == 0)
                && ((substr_count($G_ResetBody, "X-MANUALRESETURL-X") == 0)
                    || (substr_count($G_ResetBody, "X-USERNAME-X") == 0)
                    || (substr_count($G_ResetBody, "X-RESETCODE-X") == 0)))
        {
            # set error flag
            $G_ErrorWithResetBody = TRUE;
        }

        # if mail change e-mail body is invalid
        if ((substr_count($G_ChangeBody, "X-CHANGEURL-X") == 0)
                && (substr_count($G_ChangeBody, "X-CHANGEPARAMETERS-X") == 0)
                && ((substr_count($G_ChangeBody, "X-MANUALCHANGE-X") == 0)
                    || (substr_count($G_ChangeBody, "X-USERNAME-X") == 0)
                    || (substr_count($G_ChangeBody, "X-CHANGECODE-X") == 0)))
        {
          # set error flag
            $G_ErrorWithChangeBody = TRUE;
        }

        # if submitted values are all valid
        if (($G_ErrorWithActivationBody == FALSE)
            && ($G_ErrorWithResetBody == FALSE)
            && ($G_ErrorWithChangeBody == FALSE))
        {
            # save submitted values
            $SysConfig->PasswordMailSubject($G_ActivationSubject);
            $SysConfig->PasswordMailBody($G_ActivationBody);
            $SysConfig->PasswordResetMailSubject($G_ResetSubject);
            $SysConfig->PasswordResetMailBody($G_ResetBody);
            $SysConfig->MailChangeMailSubject($G_ChangeSubject);
            $SysConfig->MailChangeMailBody($G_ChangeBody);


            # set flag indicating editing is complete
            $G_EditingComplete = TRUE;
        }
    }
}
else
{
    # load values from system configuration
    $G_ActivationSubject = $SysConfig->PasswordMailSubject();
    $G_ActivationBody = $SysConfig->PasswordMailBody();
    $G_ResetSubject = $SysConfig->PasswordResetMailSubject();
    $G_ResetBody = $SysConfig->PasswordResetMailBody();
    $G_ChangeSubject = $SysConfig->MailChangeMailSubject();
    $G_ChangeBody = $SysConfig->MailChangeMailBody();
}

?>
