<?PHP
#
#   FILE:  ForgottenPasswordComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Password Assistance Request Completed");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------


# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

# retrieve user name or e-mail address entered
$F_UserName = isset($_POST["F_UserName"]) ? $_POST["F_UserName"]
        : (isset($_GET["UN"]) ? $_GET["UN"] : NULL);

# if e-mail address was entered
$UserFactory = new CWUserFactory();
if (User::IsValidLookingEMailAddress($F_UserName))
{
    # use e-mail address field for search
    $SearchField = "EMail";
    $SearchString = User::NormalizeEMailAddress($F_UserName);
    $ErrorCode = "EMAILNOTFOUND";
}
# else if user name was entered
elseif (User::IsValidUserName($F_UserName))
{
    # use name field for search
    $SearchField = "UserName";
    $SearchString = User::NormalizeUserName($F_UserName);
    $ErrorCode = "NAMENOTFOUND";
}
else
{
    # set error code for no value supplied
    $ErrorCode = "INVALIDNAME";
}

# if search parameters found
if (isset($SearchField))
{
    # search for matching user
    $Users = $UserFactory->FindUsers(
            $SearchString, $SearchField, "CreationDate", 0, 1);
}
$TargetUser = (isset($Users) && count($Users)) ? array_pop($Users) : NULL;

# if matching user was found
if ($TargetUser)
{
    # get forgotten password message text
    $MailTemplate = $SysConfig->PasswordResetMailSubject()."\n"
            .$SysConfig->PasswordResetMailBody();

    # set up any needed substitutions to message text
    $ResetUrlParameters = "&UN=".urlencode($TargetUser->Get("UserName"))
            ."&RC=".$TargetUser->GetResetCode();
    $Protocol = isset($_SERVER["HTTPS"]) ? "https://" : "http://";
    $ResetUrl = $Protocol.$_SERVER["SERVER_NAME"]
            .str_replace("ForgottenPasswordComplete", "ResetPassword",
            $_SERVER["REQUEST_URI"]).$ResetUrlParameters;
    $ManualResetUrl = $Protocol.$_SERVER["SERVER_NAME"]
            .str_replace("ForgottenPasswordComplete",
            "ManuallyResetPassword", $_SERVER["REQUEST_URI"]);
    $OurSubstitutions = array(
            "X-PORTALNAME-X" => $SysConfig->PortalName(),
            "X-RESETURL-X" => $ResetUrl,
            "X-RESETPARAMETERS-X" => $ResetUrlParameters,
            "X-MANUALRESETURL-X" => $ManualResetUrl,
            );

    # send forgotten password e-mail to user
    $FromAddress = $SysConfig->PortalName()." <".$SysConfig->AdminEmail().">";
    $G_EMailSent = $TargetUser->SendEMail(
            $MailTemplate, $FromAddress, $OurSubstitutions);

    # set values for use in HTML
    $G_UsedUserName = ($SearchField == "UserName");
    $G_UserName = $SearchString;
    $G_EMailAddress = $SearchString;
}
else
{
    # return to calling page with error information
    $AF->SetJumpToPage("ForgottenPassword&EC=".$ErrorCode
                    ."&EV=".urlencode($F_UserName));
}


?>
