<?PHP
#
#   FILE:  MDHome.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Metadata Tool");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTotalNumberOfResources()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["TotalNumberOfResources"]));
}

function PrintNumberOfReleasedResources()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["NumberOfReleasedResources"]));
}

function PrintNumberOfRatedResources()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["NumberOfRatedResources"]));
}

function PrintTotalNumberOfClassifications()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["TotalNumberOfClassifications"]));
}

function PrintTotalNumberOfControlledNames()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["TotalNumberOfControlledNames"]));
}

function PrintTotalSearchTerms()
{
    global $G_CollectionStats;

    print(number_format($G_CollectionStats["TotalSearchTerms"]));
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

if (!CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_CLASSADMIN, PRIV_NAMEADMIN, PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN)) {  return;  }


global $G_CollectionStats, $G_StatsUpdateTime;

$DB = new Database();

if (isset($_GET["US"]))
{
    global $AF;
    $AF->LoadFunction("UpdateCollectionStats");
    UpdateCollectionStats();
    $AF->SetJumpToPage("MDHome");
}
else
{
    $G_StatsUpdateTime = $DB->Query(
        "SELECT Updated FROM CachedValues WHERE Name='CollectionStats'",
        "Updated");

    if (time() - strtotime($G_StatsUpdateTime) > 3600) {
        global $AF;
        $AF->QueueTask("UpdateCollectionStats");
    }

    $G_CollectionStats = unserialize(
        $DB->Query(
            "SELECT Value FROM CachedValues WHERE Name='CollectionStats'",
            "Value"));

    # generate collection stats if they don't exist yet
    if ($G_CollectionStats === FALSE)
    {
        $AF->SetJumpToPage("MDHome&US");
    }
}
