<?PHP
#
#   FILE:  MetadataFieldDefinitionsHelp.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
 * Print the definitions for the given metadata fields.
 * @param array $Fields metadata fields
 */
function PrintFieldDefinitions(array $Fields)
{
    foreach ($Fields as $Field)
    {
        PrintFieldDefinition($Field);
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
 * Get all disabled metadata fields.
 * @param MetadataSchema $Schema metadata schema
 * @return an array of disabled metadata fields
 */
function GetDisabledFields(MetadataSchema $Schema)
{
    # get all enabled and disabled fields
    $Fields = $Schema->GetFields(
        NULL, MetadataSchema::MDFORDER_ALPHABETICAL, TRUE);

    foreach ($Fields as $Key => $Field)
    {
        # remove enabled fields
        if ($Field->Enabled())
        {
            unset($Fields[$Key]);
        }
    }

    return $Fields;
}

# ----- MAIN -----------------------------------------------------------------

global $H_EnabledFields;
global $H_DisabledFields;

$Schema = new MetadataSchema();

$H_EnabledFields = $Schema->GetFields(NULL, MetadataSchema::MDFORDER_ALPHABETICAL);
$H_DisabledFields = GetDisabledFields($Schema);
