<?PHP
#
#   FILE:  RegisterPortal.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Register Portal");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print list if info that will be sent when registering
function PrintRegistrationInfo()
{
    global $SysConfig;
    global $_SERVER;
    global $SPT_SoftwareVersionToDisplay;

    # general site info
    print("Software: ".(SoftwareIsCWIS() ? "CWIS" : "SPT")." ".$SPT_SoftwareVersionToDisplay."<br>\n");
    print("Site Name: <i>".$SysConfig->PortalName()."</i><br>\n");
    print("Site URI: <i>".$_SERVER["SERVER_NAME"].dirname($_SERVER["REQUEST_URI"])."</i><br>\n");
    print("Admin E-Mail: <i>".$SysConfig->AdminEmail()."</i><br>\n");

    # configuration settings
    print("Default UI: ".$SysConfig->DefaultActiveUI()."<br>\n");
    print("Current Theme: ".$SysConfig->CurrentTheme()."<br>\n");
    print("Forums: ".($SysConfig->ForumsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("User Agents: ".($SysConfig->UserAgentsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Announcements: ".($SysConfig->AnnouncementsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Multiple UIs: ".($SysConfig->AllowMultipleUIsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Ratings: ".($SysConfig->ResourceRatingsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Comments: ".($SysConfig->ResourceCommentsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Search Update: ".($SysConfig->SearchDBEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Recommender Update: ".($SysConfig->RecommenderDBEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Search Logic: ".($SysConfig->SearchTermsRequired() ? "AND" : "OR")."<br>\n");

    # resources info
    $RFactory = new ResourceFactory();
    $ResourceCount = $RFactory->GetItemCount();
    print("Resource Count: ".$ResourceCount."<br>\n");
    $ReleasedResourceCount = $RFactory->GetItemCount("ReleaseFlag = 1");
    print("Released Count: ".$ReleasedResourceCount."<br>\n");
    $RatedResourceCount = $RFactory->GetRatedResourceCount();
    print("Rating Count: ".$RatedResourceCount."<br>\n");

    $ClassFactory = new ClassificationFactory();
    $ClassCount = $ClassFactory->GetItemCount();
    print("Classification Count: ".$ClassCount."<br>\n");

    $SampleCount = $RFactory->GetItemCount("INSTR(Description, '[--SAMPLE RECORD--]') > 0");
    print("Sample Count: ".$SampleCount."<br>\n");

    $SearchEngine = new SPTSearchEngine();
    $TermCount = $SearchEngine->SearchTermCount();
    print("Search Term Count: ".$TermCount."<br>\n");

    # PHP configuration
    print("PHP Version: ".phpversion()."<br>\n");
    $Settings = array(
            "safe_mode",
            "register_globals",
            "max_execution_time",
            "memory_limit",
            "post_max_size",
            "file_uploads",
            "upload_max_filesize",
            );
    foreach ($Settings as $Setting)
    {
        $Value = ini_get($Setting);
        if (!strlen($Value)) {  $Value = "Off";  }
        if ($Value == "1") {  $Value = "On";  }
        print("PHP ".$Setting.": ".$Value."<br>\n");
    }
    $PhpInfo = GetPhpInfo();
    $Val = isset($PhpInfo["gd"]["GD Version"][0])
            ? $PhpInfo["gd"]["GD Version"][0] : "unavailable";
    print("PHP GD version: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["PNG Support"][0]))
            ? $PhpInfo["gd"]["PNG Support"][0] : "unavailable";
    print("PHP GD PNG Support: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["JPG Support"][0]))
            ? $PhpInfo["gd"]["JPG Support"][0] : "unavailable";
    print("PHP GD JPG Support: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["GIF Support"][0]))
            ? $PhpInfo["gd"]["GIF Support"][0] : "unavailable";
    print("PHP GD GIF Support: ".$Val."<br>\n");

    # operating environment
    print("MySQL Client Version: ".mysql_get_client_info()."<br>\n");
    print("MySQL Server Version: ".mysql_get_server_info()."<br>\n");
    print("MySQL Connection Type: ".mysql_get_host_info()."<br>\n");
    print("HTTP Server: <i>".$_SERVER["SERVER_SOFTWARE"]."</i><br>\n");
    print("OS Stamp: <i>".$PhpInfo[""]["System"][0]."</i><br>\n");
}

# print current content of user-entered registration settings
function PrintContactName() {  global $SysConfig;  print($SysConfig->ContactName());  }
function PrintContactEmail() {  global $SysConfig;  print($SysConfig->ContactEmail());  }
function PrintOrganization() {  global $SysConfig;  print($SysConfig->Organization());  }
function PrintOrganizationType() {  global $SysConfig;  print($SysConfig->OrganizationType());  }
function PrintSiteType() {  global $SysConfig;  print($SysConfig->SiteType());  }
function PrintOkayToListSite() {  global $SysConfig;  print($SysConfig->OkayToListSite());  }
function PrintCheckedIfOrganizationTypeIs($OrganizationType) {  global $SysConfig;  print(($SysConfig->OrganizationType() == $OrganizationType) ? " checked" : "");  }
function PrintCheckedIfSiteTypeIs($SiteType) {  global $SysConfig;  print(($SysConfig->SiteType() == $SiteType) ? " checked" : "");  }
function PrintCheckedIfOkayToListSite() {  global $SysConfig;  print(($SysConfig->OkayToListSite()) ? " checked" : "");  }


# ----- LOCAL FUNCTIONS ------------------------------------------------------


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $SPT_SoftwareVersionToDisplay;
global $_SERVER;

if (!CheckAuthorization( PRIV_SYSADMIN )) {  return;  }

?>
