<?PHP

class UrlChecker_StatusLine
{

    /**
     * Constructor: Parse the status line.
     * @param $StatusLine an HTTP status line
     */
    public function __construct($StatusLine)
    {
        $this->StatusLine = trim($StatusLine);

        # rejects most invalid status lines: the expression for the reason
        # phrase isn't technically correct
        if (preg_match('/(HTTP\/(0|[1-9][0-9]*)\.(0|[1-9][0-9]*))\s'
            .'([1-5][0-9]{2})\s([^\r\n]+)/', $this->StatusLine, $Matches))
        {
            list(, $Version,,, $Code, $Phrase) = $Matches;
            $this->HttpVersion = $Version;
            $this->StatusCode = intval($Code);
            $this->ReasonPhrase = $Phrase;
        }
    }

    /**
     * Get the full status line.
     * @return the full status line
     */
    public function GetStatusLine()
    {
        return $this->StatusLine;
    }

    /**
     * Get the HTTP version.
     * @return the HTTP version
     */
    public function GetHttpVersion()
    {
        return $this->HttpVersion;
    }

    /**
     * Get the status code.
     * @return the status code
     */
    public function GetStatusCode()
    {
        return $this->StatusCode;
    }

    /**
     * Get the reason phrase.
     * @return the reason phrase
     */
    public function GetReasonPhrase()
    {
        return $this->ReasonPhrase;
    }

    private $StatusLine;
    private $HttpVersion;
    private $StatusCode;
    private $ReasonPhrase;

}
