<?PHP
#
#   FILE:  ControlledNameFactory.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Factory for manipulating ControlledName objects.
*/
class ControlledNameFactory extends ItemFactory {

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
    * Constructor for ControlledNameFactory class.
    * @param int $FieldId ID of Controlled Name metadata field.  (OPTIONAL)
    */
    function __construct($FieldId = NULL)
    {
        # save field ID for our later use
        $this->FieldId = $FieldId;

        # set up item factory base class
        $this->ItemFactory("ControlledName", "ControlledNames",
                "ControlledNameId", "ControlledName", FALSE,
                ($FieldId ? "FieldId = ".intval($FieldId) : NULL));
    }

    /**
    * Determine how many resources have controlled names (associated with this
    *   metadata field) assigned to them.
    * @return Count of resources with names assigned.
    **/
    function GetUsageCount()
    {
        return $this->DB->Query(
                "SELECT COUNT(DISTINCT RNI.ResourceId) AS ResourceCount"
                ." FROM ResourceNameInts RNI, ControlledNames CN"
                ." WHERE CN.FieldId = ".intval($this->FieldId)
                ." AND RNI.ControlledNameId = CN.ControlledNameId"
                ." AND RNI.ResourceId >= 0",
                "ResourceCount");
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------

    private $FieldId;
}

