<?PHP
#
#   FILE:  EditClassificationComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2001-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# delete classifications
function ConfirmDeleteClassification()
{
    global $ClassId;

    $Class = new Classification($ClassId);

    # first delete all child classes -- USER HAS BEEN WARNED!
    $ChildList = $Class->ChildList();
    foreach ($ChildList as $ChildId)
    {
        $ChildClass = new Classification($ChildId);
        $ChildClass->Delete(FALSE, TRUE, TRUE);
    }
    $Class->Delete(FALSE, TRUE, TRUE);
}

# save classifications
function SaveClassification()
{
    global $Class, $_POST, $ErrorMessages;

    $DB = new Database();

    # if new classification segment name is valid
    $F_NewSegmentName = trim($_POST["F_NewSegmentName"]);
    if (isset($_POST["F_QualifierId"]))
        $F_QualifierId = $_POST["F_QualifierId"];
    if (strlen($F_NewSegmentName) > 0)
    {
        # save new classification segment name
        $Class->SegmentName($F_NewSegmentName);

        # save qualifier Id
        if (isset($F_QualifierId))
            $Class->QualifierId(($F_QualifierId == "--") ? 0 : $F_QualifierId);

        # rebuild full classification name
        $Class->RecalcDepthAndFullName();
    }
    else
    {
        # add message to error list
        $ErrorMessages = new ErrorList();
        $ErrorMessages->AddMessage(
        "There was an error with the classification segment name you entered.");
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Class;
global $ClassId;
global $ErrorMessages;

# check if current user is authorized
if (!CheckAuthorization(PRIV_CLASSADMIN)) {  return;  }

$ErrorMessages = $Session->Get("ErrorMessages");
if (isset($_POST["F_ClassificationId"]))
    $ClassId = $_POST["F_ClassificationId"];
else
    $ClassId = $Session->Get("ClassId");

$Submit = $_POST["Submit"];

# clear any old error info
if (isset($ErrorMessages))
{
    unset($ErrorMessages);
    $Session->UnregisterVariable("ErrorMessages");
}

# pull up existing classification record
$Class = new Classification($ClassId);

# check for actual deletion
if ($Submit == "Confirm Delete Classification")
{
    ConfirmDeleteClassification();
    $AF->SetJumpToPage("EditClassifications&FieldId=".$Class->FieldId()
                       ."&ParentId=".$Class->ParentId());
}
elseif ($Submit == "Delete Classification")
{
    $Session->PassVariable("ClassId", $ClassId);
    $AF->SetJumpToPage("index.php?P=ConfirmDeleteClassification&".
                       "action=Classification".
                       "&target=index.php%3fP%3dEditClassificationComplete");
}
# else if save changes was requested
elseif ($Submit != "Cancel")
{
    SaveClassification();
    $AF->SetJumpToPage("EditClassifications&FieldId=".$Class->FieldId()
                       ."&ParentId=".$Class->ParentId());
}
# cancel
elseif ($Submit == "Cancel")
{
    $AF->SetJumpToPage("EditClassifications&FieldId=".$Class->FieldId()
                       ."&ParentId=".$Class->ParentId());
}

# if errors were found
if (isset($ErrorMessages))
{
    # return to editing page with error messages
    $Session->RegisterVariable("ErrorMessages");
    $AF->SetJumpToPage("EditClassification&ClassificationId=".$ClassId);
}
