<?PHP
#
#   FILE:  EditTopicComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# Bail if the user wasn't authorized
if (!CheckAuthorization(PRIV_SYSADMIN))
    return;

global $AF;

# And bail if the required params weren't passed
if (!isset($_POST["F_TopicName"]) || !isset($_GET["TI"]) )
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# Otherwise, get out the target topic:
$Topic = new Topic( intval($_GET["TI"]) );

# Bounce the user if the topic specified wasn't valid.
if ($Topic->GetErrorStatus() != Topic::OK)
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

# And updated the TopicName, removing unwanted HTML
$Topic->TopicName(StripXSSThreats( $_POST["F_TopicName"]) );

# Then bounce back to the topic index page:
$AF->SetJumpToPage("index.php?P=TopicMessages"
                   ."&TI=".$Topic->TopicId() );
