<?PHP
#
#   FILE:  PostMessageComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

if (!CheckAuthorization( PRIV_POSTTOFORUMS, PRIV_FORUMADMIN, PRIV_SYSADMIN )) {  return;  }

global $AF;

if (!isset($_POST["F_Submit"]) ||
    !isset($_GET["TI"]) )
{
    $AF->SetJumpToPage("UnauthorizedAccess");
    return;
}

if (isset($_GET["MI"]))
    $MessageId = intval($_GET["MI"]);

$F_Submit = $_POST["F_Submit"];
$TopicId = intval($_GET["TI"]);

# Default place that we'll bounce the user towards:
$DestinationUrl = "index.php?P=TopicMessages&TI=".$TopicId ;

# If we aren't deleting a message, then do error checking on the message contents:
if ( !($F_Submit == "Delete Message" && isset($MessageId) ))
{
    $F_Subject = $_POST["F_Subject"];
    $F_Body = $_POST["F_Body"];

    $CommentStatus = $AF->SignalEvent("EVENT_VALIDATE_USER_COMMENT",
                                      array($F_Subject, $F_Body));

    if (!strlen($F_Subject))
        $ErrorMessages []= "No subject provided";
    if (!strlen($F_Body))
        $ErrorMessages []= "No Body provided";
    if ( $CommentStatus[0] === FALSE)
        $ErrorMessages []= $CommentStatus[1];
}

if ($F_Submit == "Preview" || $F_Submit == "Edit Message")
{
    # Put the subject and body into the session:
    $_SESSION["Subject"]  = $F_Subject;
    $_SESSION["Body"]     = $F_Body;

    # Reoute to preview if user requested it and nothing was wrong.
    # otherwise, route back to post message:
    if ($F_Submit == "Preview" && ! isset($ErrorMessages) )
        $DestinationUrl = "index.php?P=PreviewMessage&TI=".$TopicId;
    else
        $DestinationUrl = "index.php?P=PostMessage&TI=".$TopicId;
}
else if ($F_Submit == "Post New Message" || $F_Submit == "Update Message")
{
    # If nothing was wrong, post the message:
    if ( !isset($ErrorMessages))
    {
        global $G_User;

        if ($F_Submit == "Post New Message")
        {
            $Topic = new Topic($TopicId);
            if ($Topic->GetErrorStatus() == Topic::OK)
            {
                $Forum = new Forum($Topic->ForumId());
                if ($Forum->GetErrorStatus() == Forum::OK )
                    $Forum->PostMessage($TopicId, $G_User, $F_Subject, $F_Body);
            }
        }
        else
        {
            # Otherwise, we're updating:
            $Message = new Message($MessageId);
            if ($Message->GetErrorStatus() == Message::OK)
            {
                $Message->Body($F_Body);
                $Message->Subject($F_Subject);
                $Message->DateEdited(date("YmdHis"));
                $Message->EditorId($G_User->Id());
            }
        }
    }
    else
    {
        # Otherwise, send back to PostMessage to display an error page:
        $DestinationUrl =  "index.php?P=PostMessage&TI=".$TopicId;

        $_SESSION["Body"] = $F_Body;
        $_SESSION["Subject"] = $F_Subject;
    }
}
else if ($F_Submit == "Delete Message" && isset($MessageId) )
{
    Forum::DeleteMessage( $MessageId );
}

if (isset($MessageId))
    $DestinationUrl .= "&MI=".$MessageId;

if (isset($ErrorMessages))
    $_SESSION["ErrorMessages"] = $ErrorMessages;

$AF->SetJumpToPage( $DestinationUrl );
