<?PHP
#
#   FILE:  RecommendResources.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2002-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

ParseArguments();
PageTitle("Recommend Resources");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintRecommendations()
{
    global $Recommendations;
    global $CurrentResourceId;

    # make sure recommendations have been generated
    GetRecommendations();

    # for each recommended result
    foreach ($Recommendations as $ResourceId => $Score)
    {
        # export resource ID for use by other functions
        $CurrentResourceId = $ResourceId;

        # print entry
        $Resource = new Resource($ResourceId);
        global $G_User;
        PrintRecommendation($Resource,
                "index.php?P=FullRecord&amp;ID=".$ResourceId,
                $Resource->UserCanEdit($G_User),
                "index.php?P=EditResource&amp;ID=".$ResourceId,
                $Resource->ScaledCumulativeRating());
    }
}

function GetWhyRecommendLink()
{
    global $CurrentResourceId;
    return "index.php?P=WhyRecommend&amp;rr=".$CurrentResourceId;
}

function PrintTotalNumberOfResults()
{
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    print($Recommender->NumberOfResults());
}

function PrintStartingResultNumber()
{
    global $StartingResult;
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    if ($Recommender->NumberOfResults() == 0)
    {
        print("0");
    }
    else
    {
        print($StartingResult + 1);
    }
}

function PrintEndingResultNumber()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    print(min(($StartingResult + $ResultsPerPage), $Recommender->NumberOfResults()));
}

function PreviousResultsAvailable()
{
    global $StartingResult;

    return ($StartingResult > 0) ? TRUE : FALSE;
}

function NextResultsAvailable()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    return (($StartingResult + $ResultsPerPage) < $Recommender->NumberOfResults()) ? TRUE : FALSE;
}

function PrintPreviousResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $SearchString;

    $NewStartingResult = max(($StartingResult - $ResultsPerPage), 0);
    print("index.php?P=RecommendResources&amp;sr=".$NewStartingResult);
}

function PrintNextResultsLink()
{
    global $StartingResult;
    global $ResultsPerPage;
    global $SearchString;

    $NewStartingResult = $StartingResult + $ResultsPerPage;
    print("index.php?P=RecommendResources&amp;sr=".$NewStartingResult);
}

function NoResultsFound()
{
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    return ($Recommender->NumberOfResults() == 0) ? TRUE : FALSE;
}

function PrintSearchTime()
{
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    printf("%.3f", $Recommender->SearchTime());
}

function PrintNumberOfPreviousResults()
{
    global $ResultsPerPage;

    print($ResultsPerPage);
}

function PrintNumberOfNextResults()
{
    global $ResultsPerPage;
    global $StartingResult;
    global $Recommender;

    # make sure recommendations have been generated
    GetRecommendations();

    print(min($ResultsPerPage, ($Recommender->NumberOfResults() - ($StartingResult + $ResultsPerPage))));
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------

function ParseArguments()
{
    global $_GET;
    global $StartingResult;
    global $ResultsPerPage;

    # grab starting result number if passed in
    if (isset($_GET["sr"]))
    {
        $StartingResult = $_GET["sr"];
    }
    else
    {
        $StartingResult = 0;
    }

    # set results per page to a default for now
    $ResultsPerPage = 10;
}

function GetRecommendations()
{
    global $User;
    global $Recommender;
    global $Recommendations;
    global $StartingResult;
    global $ResultsPerPage;

    # bail out if we've already gotten recommendations
    static $AlreadyGotRecommendations;
    if ($AlreadyGotRecommendations) {  return;  }
    $AlreadyGotRecommendations = TRUE;

    # create recommender
    $Recommender = new SPTRecommender;

    # add filter function to return only released records
    $Recommender->AddResultFilterFunction("FilterRecommendationsForReleasedRecords");

    # get recommendations
    $Recommendations = $Recommender->Recommend($User->Get("UserId"),
            $StartingResult, $ResultsPerPage);
}

# filter the search results for only released records
function FilterRecommendationsForReleasedRecords($ResourceId)
{
    $Resource = new Resource($ResourceId);
    return ($Resource->Get("ReleaseFlag") ? FALSE : TRUE);
}


# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $CurrentResourceId;
global $Recommendations;
global $Recommender;
global $ResultsPerPage;
global $SearchString;
global $StartingResult;
