<?PHP
#
#   FILE:  Entry.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

$H_Blog = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

# assume that a generic error will occur
$H_State = "Error";

# get objet parameters
$EntryId = GetArrayValue($_GET, "EntryId");

# if the entry ID looks invalid
if (!is_numeric($EntryId))
{
    $H_State = "Invalid ID";
    return;
}

$H_Entry = new Blog_Entry($EntryId);

# if the entry ID actually is invalid
if ($H_Entry->Status() !== 1)
{
    $H_State = "Invalid ID";
    return;
}

# if the entry is some other type of resource
if (!$H_Blog->IsBlogEntry($H_Entry))
{
    $H_State = "Not Blog Entry";
    return;
}

$PublicationDate = $H_Entry->Get(Blog::PUBLICATION_DATE_FIELD_NAME);

# if the entry hasn't been published yet and the user can't view unpublished
# entries
if (time() < strtotime($PublicationDate)
    && !$H_Blog->UserCanViewUnpublishedEntries($GLOBALS["G_User"], $H_Entry))
{
    $H_State = "Not Published";
    return;
}

# get the blog entry's metrics
$H_Metrics = $H_Blog->GetBlogEntryMetrics($H_Entry);

# record an event
$H_Blog->RecordBlogEntryView($H_Entry);

# everything is fine
$H_State = "OK";
