<?PHP
#
#   FILE:  ListEvents.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Calendar Events");

# get the plugin
$H_Plugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

# don't allow unauthorized access
if (!$H_Plugin->UserCanEditEvents($GLOBALS["G_User"]))
{
    CheckAuthorization(FALSE);
    return;
}

$Schema = new MetadataSchema($H_Plugin->GetSchemaId());
$ModificationField = $Schema->GetFieldByName("Date of Modification");
$DBFieldName = $ModificationField->DBFieldName();

# set up some basic values
$H_SortField = GetFormValue("SF", $DBFieldName);
$H_SortAscending = GetFormValue("SA", 0);
$H_StartingIndex = GetFormValue("SI", 0);
$H_EventsPerPage = 50;
$H_SchemaId = $H_Plugin->GetSchemaId();
$H_Events = array();
$H_EventCountsByTense = $H_Plugin->GetEventCountsByTense();

# fetch the events
$Factory = new ResourceFactory($H_SchemaId);
$EventIds = $Factory->GetItemIds(NULL, FALSE, $H_SortField, $H_SortAscending);
$H_EventCount = count($EventIds);

# calculate ID array checksum and reset paging if list has changed
$H_ListChecksum = md5(serialize($EventIds));
if ($H_ListChecksum != GetFormValue("CK")) {  $H_StartingIndex = 0;  }

# prune event IDs down to just currently-selected segment
$EventIds = array_slice($EventIds, $H_StartingIndex, $H_EventsPerPage);

# load events from IDs
foreach ($EventIds as $Id)
{
    $H_Events[$Id] = new CalendarEvents_Event($Id);
}
