<?PHP
#
#   FILE:  RSS.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- MAIN -----------------------------------------------------------------

# suppress any HTML output
$AF->SuppressHTMLOutput();

$RSS = new RSS();
$DB = new Database();

# get the RSS configuration
$Query = "SELECT * FROM RSSConfiguration";
$DB->Query($Query);
$Config = $DB->FetchRow();

# setup the RSS channel
$RSS->AddChannel(
    $SysConfig->PortalName() . " Event Updates",
    OurBaseUrl().$G_PluginManager->GetPlugin("CalendarEvents")->EventsListUrl(),
    "Recent updates to the events for " . $SysConfig->PortalName(),
    OurBaseUrl()."index.php?P=P_CalendarEvents_RSS");

# set other values
$RSS->SetEncoding($SysConfig->DefaultCharacterSet());
$RSS->SetLanguage(GetArrayValue($Config, "Language"));
$RSS->SetCopyright(GetArrayValue($Config, "CopyRight"));
$RSS->SetManagingEditor(GetArrayValue($Config, "ManagingEditor"));
$RSS->SetWebmaster(GetArrayValue($Config, "Webmaster"));
$RSS->SetPicsRating(GetArrayValue($Config, "PicsRating"));
$RSS->SetPublicationDate(date("Y-m-d H:i:s"));

$EventsPlugin = $G_PluginManager->GetPlugin("CalendarEvents");
$Factory = new ResourceFactory($EventsPlugin->GetSchemaId());
$LastUpdate = NULL;

# get the list of recently modified events
$Ids = $Factory->GetResourceIdsSortedBy("Date of Modification", FALSE, 30);

foreach ($Ids as $Id)
{
    # skip temp events
    if ($Id < 1)
    {
        continue;
    }

    $Event = new CalendarEvents_Event($Id);

    # skip invalid or unreleased events
    if ($Event->Status() !== 1 || !$Event->Get("Release Flag"))
    {
        continue;
    }

    # add the event to the feed
    $RSS->AddItem(
        strip_tags($Event->Get("Title")),
        $Event->EventUrl(),
        strip_tags($Event->Get("Description")),
        $Event->Get("Date of Modification"));

    # set the last update time if not already set
    if (!isset($LastUpdate))
    {
        $LastUpdate = $Event->Get("Date of Modification");
    }
}

# set the date of the most recent update to the events if available
if (isset($LastUpdate))
{
    $RSS->SetLastChangeDate($LastUpdate);
}

# publish the feed
$RSS->PrintRSS();
